/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.rail.vanillaslope;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DetectorRailBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.block.render.FramedBlockRenderProperties;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.ISlopeBlock;
import xfacthd.framedblocks.common.block.rail.fancyslope.FramedFancyDetectorRailSlopeBlock;
import xfacthd.framedblocks.common.blockentity.doubled.rail.FramedFancyRailSlopeBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.FramedUtils;

public class FramedDetectorRailSlopeBlock
extends DetectorRailBlock
implements IFramedBlock,
ISlopeBlock.IRailSlopeBlock {
    private final BlockType type;
    private final ShapeProvider shapes;
    private final BiFunction<BlockPos, BlockState, FramedBlockEntity> beFactory;

    protected FramedDetectorRailSlopeBlock(BlockType type, BiFunction<BlockPos, BlockState, FramedBlockEntity> beFactory) {
        super(IFramedBlock.createProperties(type));
        this.type = type;
        this.shapes = type.generateShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
        this.beFactory = beFactory;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.PROPAGATES_SKYLIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected void registerDefaultState() {
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PropertyHolder.ASCENDING_RAIL_SHAPE, BlockStateProperties.POWERED, BlockStateProperties.WATERLOGGED, FramedProperties.SOLID, FramedProperties.GLOWING, FramedProperties.Y_SLOPE, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of((Block)this, ctx).withCustom((state, modCtx) -> (BlockState)state.setValue(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)FramedUtils.getAscendingRailShapeFromDirection(modCtx.getHorizontalDirection())))).withWater()).build();
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        BlockState newState = super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
        if (newState == state) {
            this.updateCulling((LevelReader)level, currentPos);
        }
        return newState;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.updateCulling((LevelReader)level, pos);
        if (!level.isClientSide() && level.getBlockState(pos).is((Block)this)) {
            this.updateState(state, level, pos, block);
        }
    }

    public Property<RailShape> getShapeProperty() {
        return PropertyHolder.ASCENDING_RAIL_SHAPE;
    }

    public boolean isValidRailShape(RailShape shape) {
        return shape.isAscending();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleUse(state, level, pos, player, hand, hit);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return this.useCamoOcclusionShapeForLightOcclusion(state);
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoOcclusionShape(state, level, pos);
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.getCamoVisualShape(state, level, pos, ctx);
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoShadeBrightness(state, level, pos, super.getShadeBrightness(state, level, pos));
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)FramedProperties.PROPAGATES_SKYLIGHT);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return this.getCamoDrops(super.getDrops(state, builder), builder);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.shapes.get(state);
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ctx;
        if (context instanceof EntityCollisionContext && (ctx = (EntityCollisionContext)context).getEntity() instanceof AbstractMinecart) {
            return Shapes.empty();
        }
        return this.getShape(state, worldIn, pos, context);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        Direction dir = FramedUtils.getDirectionFromAscendingRailShape((RailShape)state.getValue(PropertyHolder.ASCENDING_RAIL_SHAPE));
        dir = rot.rotate(dir);
        return (BlockState)state.setValue(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)FramedUtils.getAscendingRailShapeFromDirection(dir));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction dir = FramedUtils.getDirectionFromAscendingRailShape((RailShape)state.getValue(PropertyHolder.ASCENDING_RAIL_SHAPE));
        if (mirror == Mirror.FRONT_BACK && Utils.isZ(dir) || mirror == Mirror.LEFT_RIGHT && Utils.isX(dir)) {
            dir = dir.getOpposite();
            return (BlockState)state.setValue(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)FramedUtils.getAscendingRailShapeFromDirection(dir));
        }
        return state;
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    @Override
    public final BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.beFactory.apply(pos, state);
    }

    @Override
    public BlockType getBlockType() {
        return this.type;
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(FramedBlockRenderProperties.INSTANCE);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
    }

    @Override
    public Class<? extends Block> getJadeTargetClass() {
        return FramedDetectorRailSlopeBlock.class;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }

    public static FramedDetectorRailSlopeBlock normal() {
        return new FramedDetectorRailSlopeBlock(BlockType.FRAMED_DETECTOR_RAIL_SLOPE, FramedBlockEntity::new);
    }

    public static FramedDetectorRailSlopeBlock fancy() {
        return new FramedFancyDetectorRailSlopeBlock(FramedFancyRailSlopeBlockEntity::new);
    }
}

