/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.rail.fancyslope;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedDoubleBlock;
import xfacthd.framedblocks.common.block.ISlopeBlock;
import xfacthd.framedblocks.common.block.rail.vanillaslope.FramedPoweredRailSlopeBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.FramedDoubleBlockRenderProperties;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.util.FramedUtils;

public class FramedFancyPoweredRailSlopeBlock
extends FramedPoweredRailSlopeBlock
implements IFramedDoubleBlock,
ISlopeBlock.IRailSlopeBlock {
    public FramedFancyPoweredRailSlopeBlock(BlockType type, boolean isPoweredRail, BiFunction<BlockPos, BlockState, FramedBlockEntity> beFactory) {
        super(type, isPoweredRail, beFactory);
    }

    @Override
    @Nullable
    public BlockState runOcclusionTestAndGetLookupState(SideSkipPredicate pred, BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Tuple statePair = this.getBlockPair(adjState);
        return super.runOcclusionTestAndGetLookupState(pred, level, pos, state, (BlockState)statePair.getA(), side);
    }

    @Override
    @Nullable
    public BlockState getComponentBySkipPredicate(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction side) {
        BlockState slopeState = (BlockState)this.getBlockPair(state).getA();
        if (IFramedDoubleBlock.testComponent(level, pos, slopeState, neighborState, side)) {
            return slopeState;
        }
        return null;
    }

    @Override
    public ModelData unpackNestedModelData(ModelData data, BlockState state, BlockState componentState) {
        return Objects.requireNonNullElse((ModelData)data.get(FramedDoubleBlockEntity.DATA_LEFT), ModelData.EMPTY);
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return DoubleBlockTopInteractionMode.FIRST;
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        RailShape shape = (RailShape)state.getValue(PropertyHolder.ASCENDING_RAIL_SHAPE);
        boolean ySlope = (Boolean)state.getValue((Property)FramedProperties.Y_SLOPE);
        BlockState railState = ((Block)(switch (this.getBlockType()) {
            case BlockType.FRAMED_FANCY_POWERED_RAIL_SLOPE -> FBContent.BLOCK_FRAMED_FANCY_POWERED_RAIL;
            case BlockType.FRAMED_FANCY_ACTIVATOR_RAIL_SLOPE -> FBContent.BLOCK_FRAMED_FANCY_ACTIVATOR_RAIL;
            default -> throw new IllegalArgumentException("Invalid block type");
        }).value()).defaultBlockState();
        Direction facing = FramedUtils.getDirectionFromAscendingRailShape(shape);
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLOPE.value()).defaultBlockState().setValue(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.BOTTOM))).setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)railState.setValue((Property)BlockStateProperties.RAIL_SHAPE_STRAIGHT, (Comparable)shape)));
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing = this.getFacing(state);
        if (side == facing || side == Direction.DOWN) {
            return CamoGetter.FIRST;
        }
        if (!(side.getAxis() == facing.getAxis() || Utils.isY(side) || edge != facing && edge != Direction.DOWN)) {
            return CamoGetter.FIRST;
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        if (side == Direction.DOWN || side == this.getFacing(state)) {
            return SolidityCheck.FIRST;
        }
        return SolidityCheck.NONE;
    }

    @Override
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(FramedDoubleBlockRenderProperties.INSTANCE);
    }
}

