/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.prism;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.prism.FramedSlopedPrismBlock;
import xfacthd.framedblocks.common.block.prism.IFramedPrismBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CompoundDirection;

public class FramedElevatedSlopedPrismBlock
extends FramedBlock
implements IFramedPrismBlock {
    public FramedElevatedSlopedPrismBlock(BlockType type) {
        super(type);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(PropertyHolder.FACING_DIR, (Comparable)((Object)CompoundDirection.NORTH_UP))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PropertyHolder.FACING_DIR, BlockStateProperties.WATERLOGGED, FramedProperties.SOLID, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return FramedSlopedPrismBlock.getStateForPlacement(context, this);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.getValue(PropertyHolder.FACING_DIR));
        return (BlockState)state.setValue(PropertyHolder.FACING_DIR, (Comparable)((Object)cmpDir.rotate(rot)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.getValue(PropertyHolder.FACING_DIR));
        return (BlockState)state.setValue(PropertyHolder.FACING_DIR, (Comparable)((Object)cmpDir.mirror(mirror)));
    }

    @Override
    public BlockState getItemModelSource() {
        boolean inner = this.getBlockType() == BlockType.FRAMED_ELEVATED_INNER_SLOPED_PRISM;
        CompoundDirection cmpDir = inner ? CompoundDirection.UP_EAST : CompoundDirection.UP_WEST;
        return (BlockState)this.defaultBlockState().setValue(PropertyHolder.FACING_DIR, (Comparable)((Object)cmpDir));
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }

    @Override
    public boolean isInnerPrism() {
        return this.getBlockType() == BlockType.FRAMED_ELEVATED_INNER_SLOPED_PRISM;
    }

    public static ShapeProvider generateInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBottom = ShapeUtils.orUnoptimized(FramedElevatedSlopedPrismBlock.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)12.0, (double)0.0, (double)0.0, (double)15.5, (double)15.5, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.5, (double)0.0, (double)0.0, (double)4.0, (double)15.5, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.5, (double)0.0, (double)12.0, (double)15.5, (double)15.5, (double)15.5));
        VoxelShape shapeTop = ShapeUtils.orUnoptimized(FramedElevatedSlopedPrismBlock.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)12.0, (double)0.5, (double)0.0, (double)15.5, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.5, (double)0.5, (double)0.0, (double)4.0, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.5, (double)0.5, (double)12.0, (double)15.5, (double)16.0, (double)15.5));
        VoxelShape shapeRight = ShapeUtils.orUnoptimized(FramedElevatedSlopedPrismBlock.box((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.0, (double)0.5, (double)0.5, (double)16.0, (double)4.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.0, (double)12.0, (double)0.5, (double)16.0, (double)15.5, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.5, (double)0.5, (double)0.5, (double)4.0, (double)15.5, (double)16.0));
        VoxelShape shapeLeft = ShapeUtils.orUnoptimized(FramedElevatedSlopedPrismBlock.box((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.0, (double)12.0, (double)0.5, (double)16.0, (double)15.5, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.0, (double)0.5, (double)0.5, (double)16.0, (double)4.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)12.0, (double)0.5, (double)0.5, (double)15.5, (double)15.5, (double)16.0));
        VoxelShape shapeUp = ShapeUtils.orUnoptimized(FramedElevatedSlopedPrismBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)12.0, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.5, (double)0.0, (double)0.5, (double)4.0, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.5, (double)0.5, (double)0.5, (double)15.5, (double)4.0, (double)16.0));
        VoxelShape shapeDown = ShapeUtils.orUnoptimized(FramedElevatedSlopedPrismBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.5, (double)0.0, (double)0.5, (double)4.0, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)12.0, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedElevatedSlopedPrismBlock.box((double)0.5, (double)12.0, (double)0.5, (double)15.5, (double)15.5, (double)16.0));
        VoxelShape[] shapes = new VoxelShape[CompoundDirection.COUNT];
        for (CompoundDirection cmpDir : CompoundDirection.values()) {
            VoxelShape shape;
            Direction facing = cmpDir.direction();
            Direction orientation = cmpDir.orientation();
            if (Utils.isY(facing)) {
                shapes[cmpDir.ordinal()] = ShapeUtils.rotateShapeAroundY(Direction.NORTH, orientation, facing == Direction.UP ? shapeBottom : shapeTop);
                continue;
            }
            if (orientation == Direction.UP) {
                shape = shapeUp;
            } else if (orientation == Direction.DOWN) {
                shape = shapeDown;
            } else if (orientation == facing.getClockWise()) {
                shape = shapeRight;
            } else if (orientation == facing.getCounterClockWise()) {
                shape = shapeLeft;
            } else {
                throw new IllegalArgumentException("Invalid orientation for direction!");
            }
            shapes[cmpDir.ordinal()] = ShapeUtils.rotateShapeAroundY(Direction.NORTH, facing, shape);
        }
        for (BlockState state : states) {
            CompoundDirection cmpDir = (CompoundDirection)((Object)state.getValue(PropertyHolder.FACING_DIR));
            builder.put((Object)state, (Object)shapes[cmpDir.ordinal()]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

