/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.pillar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.stairs.vertical.FramedVerticalStairsBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.property.StairsType;

public class FramedThreewayCornerPillarBlock
extends FramedBlock {
    public FramedThreewayCornerPillarBlock() {
        super(BlockType.FRAMED_THREEWAY_CORNER_PILLAR);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withHalfFacing()).withTop()).withWater()).build();
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = rot.rotate((Direction)state.getValue((Property)FramedProperties.FACING_HOR));
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir);
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.cycle((Property)FramedProperties.TOP);
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.WEST);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(FramedVerticalStairsBlock.SHAPES.get(new FramedVerticalStairsBlock.ShapeKey(Direction.NORTH, StairsType.TOP_BOTH)), FramedVerticalStairsBlock.SHAPES.get(new FramedVerticalStairsBlock.ShapeKey(Direction.NORTH, StairsType.BOTTOM_BOTH)), Direction.NORTH);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.get2DDataValue() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

