/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.pillar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedHalfPillarBlock
extends FramedBlock {
    public FramedHalfPillarBlock(BlockType blockType) {
        super(blockType);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.FACING, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withTargetFacing()).withWater()).build();
    }

    @Override
    public BlockState rotate(BlockState state, Direction side, Rotation rot) {
        if (rot != Rotation.NONE) {
            return (BlockState)state.cycle((Property)BlockStateProperties.FACING);
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)rot.rotate(dir));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, BlockStateProperties.FACING, mirror);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeNorth = FramedHalfPillarBlock.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0);
        VoxelShape shapeSouth = FramedHalfPillarBlock.box((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0);
        VoxelShape shapeEast = FramedHalfPillarBlock.box((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
        VoxelShape shapeWest = FramedHalfPillarBlock.box((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0);
        VoxelShape shapeUp = FramedHalfPillarBlock.box((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape shapeDown = FramedHalfPillarBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
        for (BlockState state : states) {
            builder.put((Object)state, (Object)(switch ((Direction)state.getValue((Property)BlockStateProperties.FACING)) {
                default -> throw new MatchException(null, null);
                case Direction.NORTH -> shapeNorth;
                case Direction.EAST -> shapeEast;
                case Direction.SOUTH -> shapeSouth;
                case Direction.WEST -> shapeWest;
                case Direction.UP -> shapeUp;
                case Direction.DOWN -> shapeDown;
            }));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

