/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.pillar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;

public class FramedDoubleThreewayCornerPillarBlock
extends AbstractFramedDoubleBlock {
    public FramedDoubleThreewayCornerPillarBlock() {
        super(BlockType.FRAMED_DOUBLE_THREEWAY_CORNER_PILLAR);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withHalfFacing()).withTop()).build();
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = rot.rotate((Direction)state.getValue((Property)FramedProperties.FACING_HOR));
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir);
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.cycle((Property)FramedProperties.TOP);
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleBlockEntity(pos, state);
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        BlockState partState = ((Block)FBContent.BLOCK_FRAMED_THREEWAY_CORNER_PILLAR.value()).defaultBlockState();
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
        return new Tuple((Object)((BlockState)((BlockState)partState.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))), (Object)((BlockState)((BlockState)partState.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getOpposite())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top))));
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        return SolidityCheck.BOTH;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction dirTwo;
        if (edge == null) {
            return CamoGetter.NONE;
        }
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
        Direction direction = dirTwo = top ? Direction.UP : Direction.DOWN;
        if (side == dirTwo && (edge == dir || edge == dir.getCounterClockWise())) {
            return CamoGetter.FIRST;
        }
        if (side == dirTwo.getOpposite() && (edge == dir.getOpposite() || edge == dir.getClockWise())) {
            return CamoGetter.SECOND;
        }
        if (side == dir && (edge == dir.getCounterClockWise() || edge == dirTwo)) {
            return CamoGetter.FIRST;
        }
        if (side == dir.getCounterClockWise() && (edge == dir || edge == dirTwo)) {
            return CamoGetter.FIRST;
        }
        if (side == dir.getOpposite() && (edge == dir.getClockWise() || edge == dirTwo.getOpposite())) {
            return CamoGetter.SECOND;
        }
        if (side == dir.getClockWise() && (edge == dir.getOpposite() || edge == dirTwo.getOpposite())) {
            return CamoGetter.SECOND;
        }
        return CamoGetter.NONE;
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.WEST);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.WEST);
    }
}

