/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.pane;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Map;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedFloorBlock
extends FramedBlock {
    public FramedFloorBlock() {
        super(BlockType.FRAMED_FLOOR_BOARD);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.TOP, BlockStateProperties.WATERLOGGED, FramedProperties.SOLID});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withTop()).withWater()).build();
    }

    @Override
    public BlockState getItemModelSource() {
        return this.defaultBlockState();
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.defaultBlockState();
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeBottom = FramedFloorBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        VoxelShape shapeTop = FramedFloorBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        UnmodifiableIterator unmodifiableIterator = states.iterator();
        while (unmodifiableIterator.hasNext()) {
            BlockState state;
            boolean top = (Boolean)(state = (BlockState)unmodifiableIterator.next()).getValue((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)(top ? shapeTop : shapeBottom));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

