/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.interactive.pressureplate;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.render.FramedBlockRenderProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.interactive.pressureplate.FramedWaterloggablePressurePlateBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedPressurePlateBlock
extends PressurePlateBlock
implements IFramedBlock {
    private static final Map<BlockType, BlockType> WATERLOGGING_SWITCH = Map.of(BlockType.FRAMED_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_PRESSURE_PLATE, BlockType.FRAMED_PRESSURE_PLATE, BlockType.FRAMED_STONE_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE, BlockType.FRAMED_STONE_PRESSURE_PLATE, BlockType.FRAMED_OBSIDIAN_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE, BlockType.FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE, BlockType.FRAMED_OBSIDIAN_PRESSURE_PLATE);
    private static final BlockSetType OBSIDIAN = BlockSetType.register((BlockSetType)new BlockSetType("framedblocks:obsidian", true, true, false, BlockSetType.PressurePlateSensitivity.MOBS, SoundType.STONE, SoundEvents.IRON_DOOR_CLOSE, SoundEvents.IRON_DOOR_OPEN, SoundEvents.IRON_TRAPDOOR_CLOSE, SoundEvents.IRON_TRAPDOOR_OPEN, SoundEvents.STONE_PRESSURE_PLATE_CLICK_OFF, SoundEvents.STONE_PRESSURE_PLATE_CLICK_ON, SoundEvents.STONE_BUTTON_CLICK_OFF, SoundEvents.STONE_BUTTON_CLICK_ON));
    private final BlockType blockType;

    protected FramedPressurePlateBlock(BlockType type, BlockSetType blockSet, BlockBehaviour.Properties props) {
        super(blockSet, props);
        this.blockType = type;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.PROPAGATES_SKYLIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleUse(state, level, pos, player, hand, hit);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        if (player.getMainHandItem().is((Item)FBContent.ITEM_FRAMED_HAMMER.value())) {
            if (!level.isClientSide()) {
                Utils.wrapInStateCopy((LevelAccessor)level, pos, player, ItemStack.EMPTY, false, false, () -> {
                    BlockState newState = this.getCounterpart().defaultBlockState();
                    level.setBlockAndUpdate(pos, newState);
                });
            }
            return true;
        }
        return false;
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoShadeBrightness(state, level, pos, super.getShadeBrightness(state, level, pos));
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)FramedProperties.PROPAGATES_SKYLIGHT);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return this.getCamoDrops(super.getDrops(state, builder), builder);
    }

    protected int getSignalStrength(Level level, BlockPos pos) {
        if (this.type == OBSIDIAN) {
            return FramedPressurePlateBlock.getEntityCount((Level)level, (AABB)TOUCH_AABB.move(pos), Player.class) > 0 ? 15 : 0;
        }
        return super.getSignalStrength(level, pos);
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    @Override
    public BlockType getBlockType() {
        return this.blockType;
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(FramedBlockRenderProperties.INSTANCE);
    }

    protected final Block getCounterpart() {
        return FBContent.byType(WATERLOGGING_SWITCH.get(this.blockType));
    }

    @Override
    public BlockState getItemModelSource() {
        return this.defaultBlockState();
    }

    @Override
    public Class<? extends Block> getJadeTargetClass() {
        return FramedPressurePlateBlock.class;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.defaultBlockState();
    }

    public static FramedPressurePlateBlock wood() {
        return new FramedPressurePlateBlock(BlockType.FRAMED_PRESSURE_PLATE, BlockSetType.OAK, IFramedBlock.createProperties(BlockType.FRAMED_PRESSURE_PLATE).noCollission().strength(0.5f));
    }

    public static FramedPressurePlateBlock woodWaterloggable() {
        return new FramedWaterloggablePressurePlateBlock(BlockType.FRAMED_WATERLOGGABLE_PRESSURE_PLATE, BlockSetType.OAK, IFramedBlock.createProperties(BlockType.FRAMED_WATERLOGGABLE_PRESSURE_PLATE).noCollission().strength(0.5f));
    }

    public static FramedPressurePlateBlock stone() {
        return new FramedPressurePlateBlock(BlockType.FRAMED_STONE_PRESSURE_PLATE, BlockSetType.STONE, IFramedBlock.createProperties(BlockType.FRAMED_STONE_PRESSURE_PLATE).requiresCorrectToolForDrops().noCollission().strength(0.5f));
    }

    public static FramedPressurePlateBlock stoneWaterloggable() {
        return new FramedWaterloggablePressurePlateBlock(BlockType.FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE, BlockSetType.STONE, IFramedBlock.createProperties(BlockType.FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE).requiresCorrectToolForDrops().noCollission().strength(0.5f));
    }

    public static FramedPressurePlateBlock obsidian() {
        return new FramedPressurePlateBlock(BlockType.FRAMED_OBSIDIAN_PRESSURE_PLATE, OBSIDIAN, IFramedBlock.createProperties(BlockType.FRAMED_OBSIDIAN_PRESSURE_PLATE).requiresCorrectToolForDrops().noCollission().strength(0.5f));
    }

    public static FramedPressurePlateBlock obsidianWaterloggable() {
        return new FramedWaterloggablePressurePlateBlock(BlockType.FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE, OBSIDIAN, IFramedBlock.createProperties(BlockType.FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE).requiresCorrectToolForDrops().noCollission().strength(0.5f));
    }
}

