/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.door;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedGateBlock
extends FramedBlock {
    private final SoundEvent closeSound;
    private final SoundEvent openSound;
    private static final ShapeCache<Direction> SHAPES = ShapeCache.createEnum(Direction.class, map -> {
        VoxelShape shape = FramedGateBlock.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
        ShapeUtils.makeHorizontalRotations(shape, Direction.NORTH, map);
    });

    private FramedGateBlock(BlockType blockType, BlockBehaviour.Properties props, SoundEvent closeSound, SoundEvent openSound) {
        super(blockType, props.pushReaction(PushReaction.DESTROY));
        this.closeSound = closeSound;
        this.openSound = openSound;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.DOOR_HINGE, BlockStateProperties.OPEN, BlockStateProperties.POWERED, FramedProperties.SOLID});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withHorizontalFacing()).withCustom((state, modCtx) -> {
            boolean powered = modCtx.getLevel().hasNeighborSignal(modCtx.getClickedPos());
            return (BlockState)((BlockState)((BlockState)state.setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)this.getHinge((BlockPlaceContext)modCtx))).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(powered))).setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(powered));
        })).build();
    }

    private DoorHingeSide getHinge(BlockPlaceContext context) {
        double xz;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction dir = context.getHorizontalDirection();
        BlockPos posLeft = pos.relative(dir.getCounterClockWise());
        BlockState stateLeft = level.getBlockState(posLeft);
        BlockPos posRight = pos.relative(dir.getClockWise());
        BlockState stateRight = level.getBlockState(posRight);
        if (stateLeft.is((Block)this) || stateRight.isCollisionShapeFullBlock((BlockGetter)level, posRight)) {
            return DoorHingeSide.RIGHT;
        }
        if (stateRight.is((Block)this) || stateLeft.isCollisionShapeFullBlock((BlockGetter)level, posLeft)) {
            return DoorHingeSide.LEFT;
        }
        Vec3 hitVec = Utils.fraction(context.getClickLocation());
        double d = xz = Utils.isX(dir) ? hitVec.z() : hitVec.x();
        if (Utils.isPositive(dir.getCounterClockWise())) {
            xz = 1.0 - xz;
        }
        return xz > 0.5 ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        InteractionResult result = super.useWithoutItem(state, level, pos, player, hit);
        if (result.consumesAction()) {
            return result;
        }
        if (this == FBContent.BLOCK_FRAMED_IRON_GATE.value()) {
            return InteractionResult.PASS;
        }
        state = (BlockState)state.cycle((Property)BlockStateProperties.OPEN);
        level.setBlockAndUpdate(pos, state);
        boolean open = (Boolean)state.getValue((Property)BlockStateProperties.OPEN);
        this.playSound((Entity)player, level, pos, open);
        level.gameEvent((Entity)player, (Holder)(open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    @Override
    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean powered = level.hasNeighborSignal(pos);
        if (!this.defaultBlockState().is(block) && powered != (Boolean)state.getValue((Property)BlockStateProperties.POWERED)) {
            if (powered != (Boolean)state.getValue((Property)BlockStateProperties.OPEN)) {
                this.playSound(null, level, pos, powered);
                level.gameEvent(null, (Holder)(powered ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
            }
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(powered))).setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(powered)), 2);
        }
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        return (BlockState)state.rotate(mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))).cycle((Property)BlockStateProperties.DOOR_HINGE);
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return switch (type) {
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)state.getValue((Property)BlockStateProperties.OPEN);
            default -> false;
        };
    }

    private void playSound(@Nullable Entity entity, Level level, BlockPos pos, boolean open) {
        level.playSound(entity, pos, open ? this.openSound : this.closeSound, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    @Override
    public BlockState getItemModelSource() {
        return this.defaultBlockState();
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.defaultBlockState();
    }

    public static FramedGateBlock wood() {
        return new FramedGateBlock(BlockType.FRAMED_GATE, IFramedBlock.createProperties(BlockType.FRAMED_GATE), SoundEvents.WOODEN_DOOR_CLOSE, SoundEvents.WOODEN_DOOR_OPEN);
    }

    public static FramedGateBlock iron() {
        return new FramedGateBlock(BlockType.FRAMED_IRON_GATE, IFramedBlock.createProperties(BlockType.FRAMED_IRON_GATE).requiresCorrectToolForDrops(), SoundEvents.IRON_DOOR_CLOSE, SoundEvents.IRON_DOOR_OPEN);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (((Boolean)state.getValue((Property)BlockStateProperties.OPEN)).booleanValue()) {
                boolean rightHinge = state.getValue((Property)BlockStateProperties.DOOR_HINGE) == DoorHingeSide.RIGHT;
                dir = rightHinge ? dir.getCounterClockWise() : dir.getClockWise();
            }
            builder.put((Object)state, (Object)SHAPES.get(dir));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

