/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.cube;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedTubeBlock
extends FramedBlock {
    public FramedTubeBlock() {
        super(BlockType.FRAMED_TUBE);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.AXIS, FramedProperties.SOLID, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withClickedAxis()).withWater()).build();
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return state.getValue((Property)BlockStateProperties.AXIS) == Direction.Axis.Y;
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeY = ShapeUtils.or(FramedTubeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), FramedTubeBlock.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), FramedTubeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), FramedTubeBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        VoxelShape shapeZ = ShapeUtils.rotateShapeAroundX(Direction.UP, Direction.SOUTH, shapeY);
        VoxelShape shapeX = ShapeUtils.rotateShapeAroundZ(Direction.UP, Direction.EAST, shapeY);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            VoxelShape shape = switch ((Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS)) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> shapeX;
                case Direction.Axis.Y -> shapeY;
                case Direction.Axis.Z -> shapeZ;
            };
            builder.put((Object)state, (Object)shape);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

