/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen.overlay;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.ConcatenatedListView;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.screen.overlay.BlockInteractOverlay;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IComplexSlopeSource;
import xfacthd.framedblocks.common.config.ClientConfig;

public final class ToggleYSlopeOverlay
extends BlockInteractOverlay {
    public static final String SLOPE_MESSAGE = Utils.translationKey("tooltip", "y_slope");
    public static final String TOGGLE_MESSAGE = Utils.translationKey("tooltip", "y_slope.toggle");
    public static final String SLOPE_MESSAGE_ALT = Utils.translationKey("tooltip", "y_slope.alt");
    public static final String TOGGLE_MESSAGE_ALT = Utils.translationKey("tooltip", "y_slope.alt.toggle");
    public static final Component SLOPE_HOR = Utils.translate("tooltip", "y_slope.horizontal");
    public static final Component SLOPE_VERT = Utils.translate("tooltip", "y_slope.vertical");
    public static final Component SLOPE_FRONT = Utils.translate("tooltip", "y_slope.front");
    public static final Component SLOPE_SIDE = Utils.translate("tooltip", "y_slope.side");
    private static final List<Component> LINES_FALSE = List.of(Component.translatable((String)SLOPE_MESSAGE, (Object[])new Object[]{SLOPE_HOR}), Component.translatable((String)TOGGLE_MESSAGE, (Object[])new Object[]{SLOPE_VERT}));
    private static final List<Component> LINES_TRUE = List.of(Component.translatable((String)SLOPE_MESSAGE, (Object[])new Object[]{SLOPE_VERT}), Component.translatable((String)TOGGLE_MESSAGE, (Object[])new Object[]{SLOPE_HOR}));
    private static final List<Component> LINES_FALSE_ALT = List.of(Component.translatable((String)SLOPE_MESSAGE_ALT, (Object[])new Object[]{SLOPE_FRONT}), Component.translatable((String)TOGGLE_MESSAGE_ALT, (Object[])new Object[]{SLOPE_SIDE}));
    private static final List<Component> LINES_TRUE_ALT = List.of(Component.translatable((String)SLOPE_MESSAGE_ALT, (Object[])new Object[]{SLOPE_SIDE}), Component.translatable((String)TOGGLE_MESSAGE_ALT, (Object[])new Object[]{SLOPE_FRONT}));
    private static final List<Component> LINES_FALSE_ALL = ConcatenatedListView.of((List[])new List[]{LINES_FALSE, LINES_FALSE_ALT});
    private static final List<Component> LINES_TRUE_ALL = ConcatenatedListView.of((List[])new List[]{LINES_TRUE, LINES_TRUE_ALT});
    private static final ResourceLocation SYMBOL_TEXTURE = Utils.rl("textures/overlay/yslope_symbols.png");
    private static final BlockInteractOverlay.Texture TEXTURE_FALSE = new BlockInteractOverlay.Texture(SYMBOL_TEXTURE, 0, 0, 20, 40, 80, 40);
    private static final BlockInteractOverlay.Texture TEXTURE_TRUE = new BlockInteractOverlay.Texture(SYMBOL_TEXTURE, 20, 0, 20, 40, 80, 40);
    private static final BlockInteractOverlay.Texture TEXTURE_ALT_FALSE = new BlockInteractOverlay.Texture(SYMBOL_TEXTURE, 40, 0, 20, 40, 80, 40);
    private static final BlockInteractOverlay.Texture TEXTURE_ALT_TRUE = new BlockInteractOverlay.Texture(SYMBOL_TEXTURE, 60, 0, 20, 40, 80, 40);

    public ToggleYSlopeOverlay() {
        super(LINES_FALSE_ALL, LINES_TRUE_ALL, TEXTURE_FALSE, TEXTURE_TRUE, ClientConfig.VIEW::getToggleYSlopeMode);
    }

    @Override
    protected boolean isValidTool(ItemStack stack) {
        return stack.getItem() == FBContent.ITEM_FRAMED_WRENCH.value();
    }

    @Override
    protected boolean isValidTarget(BlockInteractOverlay.Target target) {
        return target.state().hasProperty((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    protected boolean getState(BlockInteractOverlay.Target target) {
        return (Boolean)target.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    protected BlockInteractOverlay.Texture getTexture(BlockInteractOverlay.Target target, boolean state, BlockInteractOverlay.Texture texFalse, BlockInteractOverlay.Texture texTrue) {
        IComplexSlopeSource src;
        Block block = target.state().getBlock();
        if (block instanceof IComplexSlopeSource && (src = (IComplexSlopeSource)block).isHorizontalSlope(target.state())) {
            return state ? TEXTURE_ALT_TRUE : TEXTURE_ALT_FALSE;
        }
        return super.getTexture(target, state, texFalse, texTrue);
    }

    @Override
    protected List<Component> getLines(BlockInteractOverlay.Target target, boolean state, List<Component> linesFalse, List<Component> linesTrue) {
        IComplexSlopeSource src;
        Block block = target.state().getBlock();
        if (block instanceof IComplexSlopeSource && (src = (IComplexSlopeSource)block).isHorizontalSlope(target.state())) {
            return state ? LINES_TRUE_ALT : LINES_FALSE_ALT;
        }
        return state ? LINES_TRUE : LINES_FALSE;
    }
}

