/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen.overlay;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.screen.overlay.BlockInteractOverlay;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.interactive.FramedItemFrameBlock;
import xfacthd.framedblocks.common.config.ClientConfig;
import xfacthd.framedblocks.common.data.PropertyHolder;

public final class FrameBackgroundOverlay
extends BlockInteractOverlay {
    private static final ResourceLocation SYMBOL_TEXTURE = Utils.rl("textures/overlay/frame_background_symbols.png");
    private static final ResourceLocation LEATHER_TEXTURE = Utils.rl("minecraft", "textures/item/leather.png");
    private static final BlockInteractOverlay.Texture TEXTURE_BG = new BlockInteractOverlay.Texture(SYMBOL_TEXTURE, 0, 0, 22, 22, 38, 22);
    private static final BlockInteractOverlay.Texture TEXTURE_CROSS = new BlockInteractOverlay.Texture(SYMBOL_TEXTURE, 22, 0, 16, 16, 38, 22);
    private static final BlockInteractOverlay.Texture TEXTURE_LEATHER = new BlockInteractOverlay.Texture(LEATHER_TEXTURE, 0, 0, 16, 16, 16, 16);
    public static final Component LINE_USE_CAMO_BG = Utils.translate("tooltip", "frame_bg.use_camo");
    public static final Component LINE_USE_LEATHER_BG = Utils.translate("tooltip", "frame_bg.use_leather");
    public static final Component LINE_SET_CAMO_BG = Utils.translate("tooltip", "frame_bg.set_camo");
    public static final Component LINE_SET_LEATHER_BG = Utils.translate("tooltip", "frame_bg.set_leather");
    private static final List<Component> LINES_FALSE = List.of(LINE_USE_CAMO_BG, LINE_SET_LEATHER_BG);
    private static final List<Component> LINES_TRUE = List.of(LINE_USE_LEATHER_BG, LINE_SET_CAMO_BG);

    public FrameBackgroundOverlay() {
        super(LINES_FALSE, LINES_TRUE, null, null, ClientConfig.VIEW::getFrameBackgroundMode);
    }

    @Override
    protected boolean isValidTool(ItemStack stack) {
        return stack.is((Item)FBContent.ITEM_FRAMED_HAMMER.value());
    }

    @Override
    protected boolean isValidTarget(BlockInteractOverlay.Target target) {
        return target.state().getBlock() instanceof FramedItemFrameBlock;
    }

    @Override
    protected boolean getState(BlockInteractOverlay.Target target) {
        return (Boolean)target.state().getValue((Property)PropertyHolder.LEATHER);
    }

    @Override
    protected BlockInteractOverlay.Texture getTexture(BlockInteractOverlay.Target target, boolean state, BlockInteractOverlay.Texture texFalse, BlockInteractOverlay.Texture texTrue) {
        return TEXTURE_BG;
    }

    @Override
    protected void renderAfterIcon(GuiGraphics graphics, BlockInteractOverlay.Texture tex, int texX, int texY, BlockInteractOverlay.Target target) {
        TEXTURE_LEATHER.draw(graphics, texX + 3, texY + 3);
        if (!((Boolean)target.state().getValue((Property)PropertyHolder.LEATHER)).booleanValue()) {
            TEXTURE_CROSS.draw(graphics, texX + 3, texY + 3);
        }
    }
}

