/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.block.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.camo.block.BlockCamoContent;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.render.debug.BlockDebugRenderer;
import xfacthd.framedblocks.api.util.TestProperties;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;

public class DoubleBlockPartDebugRenderer
implements BlockDebugRenderer<FramedDoubleBlockEntity> {
    public static final DoubleBlockPartDebugRenderer INSTANCE = new DoubleBlockPartDebugRenderer();
    private static final ModelData MODEL_DATA = ModelData.builder().with(FramedBlockData.PROPERTY, (Object)new FramedBlockData(new BlockCamoContent(Blocks.STONE.defaultBlockState()), new boolean[6], false, false)).build();

    private DoubleBlockPartDebugRenderer() {
    }

    @Override
    public void render(FramedDoubleBlockEntity be, BlockHitResult blockHit, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        Tuple<BlockState, BlockState> blockPair = be.getBlockPair();
        Player player = (Player)Objects.requireNonNull(Minecraft.getInstance().player);
        boolean secondary = be.debugHitSecondary(blockHit, player);
        BlockState state = secondary ? (BlockState)blockPair.getB() : (BlockState)blockPair.getA();
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        OutlineBufferSource outlineBuffer = Minecraft.getInstance().renderBuffers().outlineBufferSource();
        outlineBuffer.setColor(secondary ? 0 : 255, secondary ? 255 : 0, 0, 255);
        VertexConsumer consumer = outlineBuffer.getBuffer(RenderType.outline((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(poseStack.last(), consumer, state, model, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY, MODEL_DATA, RenderType.solid());
    }

    @Override
    public boolean isEnabled() {
        return TestProperties.ENABLE_DOUBLE_BLOCK_PART_HIT_DEBUG_RENDERER;
    }
}

