/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.block.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.BlockHitResult;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.block.cache.StateCache;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.api.render.debug.BlockDebugRenderer;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.TestProperties;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockStateCache;

public class ConnectionPredicateDebugRenderer
implements BlockDebugRenderer<FramedBlockEntity> {
    public static final ConnectionPredicateDebugRenderer INSTANCE = new ConnectionPredicateDebugRenderer();
    private static float dummyU0 = 0.0f;
    private static float dummyU1 = 1.0f;
    private static float dummyV0 = 0.0f;
    private static float dummyV1 = 1.0f;

    private ConnectionPredicateDebugRenderer() {
    }

    @Override
    public void render(FramedBlockEntity be, BlockHitResult blockHit, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        poseStack.translate(0.5, 0.5, 0.5);
        Direction face = blockHit.getDirection();
        StateCache cache = be.getBlock().getCache(be.getBlockState());
        switch (face) {
            case UP: {
                poseStack.mulPose(Quaternions.XN_90);
                ConnectionPredicateDebugRenderer.renderIndicators(buffer, poseStack, cache, face, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
                break;
            }
            case DOWN: {
                poseStack.mulPose(Quaternions.XP_90);
                ConnectionPredicateDebugRenderer.renderIndicators(buffer, poseStack, cache, face, Direction.SOUTH, Direction.NORTH, Direction.EAST, Direction.WEST);
                break;
            }
            default: {
                poseStack.mulPose(Axis.YN.rotationDegrees(face.toYRot()));
                ConnectionPredicateDebugRenderer.renderIndicators(buffer, poseStack, cache, face, Direction.UP, Direction.DOWN, face.getCounterClockWise(), face.getClockWise());
            }
        }
    }

    private static void renderIndicators(MultiBufferSource bufferSource, PoseStack poseStack, StateCache cache, Direction face, Direction upEdge, Direction downEdge, Direction ccwEdge, Direction cwEdge) {
        DoubleBlockStateCache dbCache;
        DoubleBlockStateCache doubleCache = cache instanceof DoubleBlockStateCache ? (dbCache = (DoubleBlockStateCache)cache) : null;
        VertexConsumer buffer = bufferSource.getBuffer(Sheets.solidBlockSheet());
        int color = cache.canConnectFullEdge(face, null) ? -16711936 : -65536;
        ConnectionPredicateDebugRenderer.renderBorderedIndicator(buffer, poseStack, -0.125f, 0.125f, -0.125f, 0.125f, 0.501f, color);
        if (doubleCache != null) {
            color = doubleCache.getCamoGetter(face, null) != CamoGetter.NONE ? -16711936 : -65536;
            ConnectionPredicateDebugRenderer.renderBorderedIndicator(buffer, poseStack, -0.1875f, 0.1875f, -0.1875f, 0.1875f, color);
        }
        color = cache.canConnectFullEdge(face, upEdge) ? -16711936 : (cache.canConnectDetailed(face, upEdge) ? -22016 : -65536);
        ConnectionPredicateDebugRenderer.renderBorderedIndicator(buffer, poseStack, -0.375f, 0.375f, 0.375f, 0.5f, color);
        if (doubleCache != null) {
            color = doubleCache.getCamoGetter(face, upEdge) != CamoGetter.NONE ? -16711936 : -65536;
            ConnectionPredicateDebugRenderer.renderBorderedIndicator(buffer, poseStack, -0.25f, 0.25f, 0.3125f, 0.375f, color);
        }
        color = cache.canConnectFullEdge(face, downEdge) ? -16711936 : (cache.canConnectDetailed(face, downEdge) ? -22016 : -65536);
        ConnectionPredicateDebugRenderer.renderBorderedIndicator(buffer, poseStack, -0.375f, 0.375f, -0.5f, -0.375f, color);
        if (doubleCache != null) {
            color = doubleCache.getCamoGetter(face, downEdge) != CamoGetter.NONE ? -16711936 : -65536;
            ConnectionPredicateDebugRenderer.renderBorderedIndicator(buffer, poseStack, -0.25f, 0.25f, -0.375f, -0.3125f, color);
        }
        color = cache.canConnectFullEdge(face, ccwEdge) ? -16711936 : (cache.canConnectDetailed(face, ccwEdge) ? -22016 : -65536);
        ConnectionPredicateDebugRenderer.renderBorderedIndicator(buffer, poseStack, 0.375f, 0.5f, -0.375f, 0.375f, color);
        if (doubleCache != null) {
            color = doubleCache.getCamoGetter(face, ccwEdge) != CamoGetter.NONE ? -16711936 : -65536;
            ConnectionPredicateDebugRenderer.renderBorderedIndicator(buffer, poseStack, 0.3125f, 0.375f, -0.25f, 0.25f, color);
        }
        color = cache.canConnectFullEdge(face, cwEdge) ? -16711936 : (cache.canConnectDetailed(face, cwEdge) ? -22016 : -65536);
        ConnectionPredicateDebugRenderer.renderBorderedIndicator(buffer, poseStack, -0.5f, -0.375f, -0.375f, 0.375f, color);
        if (doubleCache != null) {
            color = doubleCache.getCamoGetter(face, cwEdge) != CamoGetter.NONE ? -16711936 : -65536;
            ConnectionPredicateDebugRenderer.renderBorderedIndicator(buffer, poseStack, -0.375f, -0.3125f, -0.25f, 0.25f, color);
        }
    }

    private static void renderBorderedIndicator(VertexConsumer buffer, PoseStack poseStack, float minX, float maxX, float minY, float maxY, int color) {
        ConnectionPredicateDebugRenderer.renderBorderedIndicator(buffer, poseStack, minX, maxX, minY, maxY, 0.5f, color);
    }

    private static void renderBorderedIndicator(VertexConsumer buffer, PoseStack poseStack, float minX, float maxX, float minY, float maxY, float z, int color) {
        PoseStack.Pose pose = poseStack.last();
        ConnectionPredicateDebugRenderer.vertex(buffer, pose, minX, maxY, z + 5.0E-4f, -16777216, dummyU0, dummyV0);
        ConnectionPredicateDebugRenderer.vertex(buffer, pose, minX, minY, z + 5.0E-4f, -16777216, dummyU0, dummyV1);
        ConnectionPredicateDebugRenderer.vertex(buffer, pose, maxX, minY, z + 5.0E-4f, -16777216, dummyU1, dummyV1);
        ConnectionPredicateDebugRenderer.vertex(buffer, pose, maxX, maxY, z + 5.0E-4f, -16777216, dummyU1, dummyV0);
        ConnectionPredicateDebugRenderer.vertex(buffer, pose, minX + 0.01f, maxY - 0.01f, z + 0.001f, color, dummyU0, dummyV0);
        ConnectionPredicateDebugRenderer.vertex(buffer, pose, minX + 0.01f, minY + 0.01f, z + 0.001f, color, dummyU0, dummyV1);
        ConnectionPredicateDebugRenderer.vertex(buffer, pose, maxX - 0.01f, minY + 0.01f, z + 0.001f, color, dummyU1, dummyV1);
        ConnectionPredicateDebugRenderer.vertex(buffer, pose, maxX - 0.01f, maxY - 0.01f, z + 0.001f, color, dummyU1, dummyV0);
    }

    private static void vertex(VertexConsumer buffer, PoseStack.Pose pose, float x, float y, float z, int color, float u, float v) {
        buffer.addVertex(pose, x, y, z).setColor(color).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, 1.0f);
    }

    public static void captureDummySprite(TextureAtlas atlas) {
        TextureAtlasSprite sprite = atlas.getSprite(ClientUtils.DUMMY_TEXTURE);
        dummyU0 = sprite.getU0();
        dummyU1 = sprite.getU1();
        dummyV0 = sprite.getV0();
        dummyV1 = sprite.getV1();
    }

    @Override
    public boolean isEnabled() {
        return TestProperties.ENABLE_CONNECTION_DEBUG_RENDERER;
    }
}

