/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.loading.FMLEnvironment;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.render.debug.AttachDebugRenderersEvent;
import xfacthd.framedblocks.api.render.debug.BlockDebugRenderer;

public class FramedBlockDebugRenderer
implements BlockEntityRenderer<FramedBlockEntity> {
    private static final Map<BlockEntityType<? extends FramedBlockEntity>, Set<BlockDebugRenderer<? extends FramedBlockEntity>>> RENDERERS_BY_TYPE = new IdentityHashMap<BlockEntityType<? extends FramedBlockEntity>, Set<BlockDebugRenderer<? extends FramedBlockEntity>>>();

    public FramedBlockDebugRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(FramedBlockEntity be, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        BlockHitResult blockHit;
        HitResult hit = Minecraft.getInstance().hitResult;
        if (!(hit instanceof BlockHitResult) || !(blockHit = (BlockHitResult)hit).getBlockPos().equals((Object)be.getBlockPos())) {
            return;
        }
        for (BlockDebugRenderer<? extends FramedBlockEntity> renderer : RENDERERS_BY_TYPE.get(be.getType())) {
            poseStack.pushPose();
            renderer.render(be, blockHit, partialTick, poseStack, buffer, light, overlay);
            poseStack.popPose();
        }
    }

    public static void init() {
        if (FMLEnvironment.production) {
            return;
        }
        ModLoader.postEvent((Event)new AttachDebugRenderersEvent((type, renderer) -> {
            if (!renderer.isEnabled()) {
                return;
            }
            RENDERERS_BY_TYPE.computeIfAbsent((BlockEntityType<? extends FramedBlockEntity>)type, $ -> new ReferenceOpenHashSet()).add(renderer);
        }));
    }

    public static Set<BlockEntityType<? extends FramedBlockEntity>> getTargetTypes() {
        return RENDERERS_BY_TYPE.keySet();
    }
}

