/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.modelwrapping;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public final class StateLocationCache {
    private static final BiMap<ModelResourceLocation, BlockState> STATE_LOCATIONS = HashBiMap.create();

    public static BlockState getStateFromLocation(ResourceLocation blockId, Block block, ModelResourceLocation id) {
        if (!STATE_LOCATIONS.containsKey((Object)id)) {
            StateLocationCache.computeStateLocationsForBlock(block, blockId);
        }
        return (BlockState)STATE_LOCATIONS.get((Object)id);
    }

    public static ModelResourceLocation getLocationFromState(BlockState state, @Nullable ResourceLocation blockId) {
        BiMap inverse = STATE_LOCATIONS.inverse();
        if (!inverse.containsKey((Object)state)) {
            if (blockId == null) {
                blockId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
            }
            StateLocationCache.computeStateLocationsForBlock(state.getBlock(), blockId);
        }
        return (ModelResourceLocation)inverse.get((Object)state);
    }

    private static void computeStateLocationsForBlock(Block block, ResourceLocation blockId) {
        block.getStateDefinition().getPossibleStates().forEach(state -> STATE_LOCATIONS.put((Object)BlockModelShaper.stateToModelLocation((ResourceLocation)blockId, (BlockState)state), state));
    }

    private StateLocationCache() {
    }
}

