/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopeslab;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.slopeslab.FramedSlopeSlabGeometry;

public class FramedCompoundSlopeSlabGeometry
extends Geometry {
    private final Direction dir;
    private final boolean ySlope;

    public FramedCompoundSlopeSlabGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (quadDir == this.dir) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).export(quadMap.get(quadDir));
            if (!this.ySlope) {
                QuadModifier.of(quad).apply(Modifiers.makeVerticalSlope(false, FramedSlopeSlabGeometry.SLOPE_ANGLE)).apply(Modifiers.offset(Direction.DOWN, 0.5f)).export(quadMap.get(null));
            }
        } else if (quadDir == this.dir.getOpposite()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).export(quadMap.get(quadDir));
            if (!this.ySlope) {
                QuadModifier.of(quad).apply(Modifiers.makeVerticalSlope(true, FramedSlopeSlabGeometry.SLOPE_ANGLE)).apply(Modifiers.offset(Direction.UP, 0.5f)).export(quadMap.get(null));
            }
        } else if (this.ySlope && Utils.isY(quadDir)) {
            Direction edge = quadDir == Direction.UP ? this.dir.getOpposite() : this.dir;
            QuadModifier.of(quad).apply(Modifiers.makeVerticalSlope(edge, FramedSlopeSlabGeometry.SLOPE_ANGLE_VERT)).export(quadMap.get(null));
        } else if (quadDir.getAxis() == this.dir.getClockWise().getAxis()) {
            boolean cw = quadDir == this.dir.getClockWise();
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, cw ? 0.5f : 1.0f, cw ? 1.0f : 0.5f)).apply(Modifiers.cutSideUpDown(true, cw ? 1.0f : 0.5f, cw ? 0.5f : 1.0f)).export(quadMap.get(null));
        }
    }
}

