/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.rail;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.client.model.slope.FramedSlopeGeometry;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.FramedUtils;

public class FramedRailSlopeGeometry
extends FramedSlopeGeometry {
    private final BlockState railState;

    private FramedRailSlopeGeometry(GeometryFactory.Context ctx, BlockState railBlock, EnumProperty<RailShape> shapeProperty) {
        super(new GeometryFactory.Context(FramedRailSlopeGeometry.getSlopeState(ctx.state()), ctx.baseModel(), ctx.modelLookup(), ctx.textureLookup()));
        RailShape shape = (RailShape)ctx.state().getValue(PropertyHolder.ASCENDING_RAIL_SHAPE);
        this.railState = (BlockState)railBlock.setValue(shapeProperty, (Comparable)shape);
    }

    @Override
    public void getAdditionalQuads(QuadMap quadMap, RandomSource rand, ModelData data, RenderType renderType) {
        quadMap.get(null).addAll(this.getRailQuads(null, rand, renderType));
        for (Direction side : Direction.values()) {
            quadMap.get(side).addAll(this.getRailQuads(side, rand, renderType));
        }
    }

    @Override
    public ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return ModelUtils.getRenderTypes(this.railState, rand, ModelData.EMPTY);
    }

    private List<BakedQuad> getRailQuads(@Nullable Direction side, RandomSource rand, RenderType layer) {
        return ModelUtils.getModel(this.railState).getQuads(this.railState, side, rand, ModelData.EMPTY, layer);
    }

    private static BlockState getSlopeState(BlockState state) {
        RailShape shape = (RailShape)state.getValue(PropertyHolder.ASCENDING_RAIL_SHAPE);
        Direction dir = FramedUtils.getDirectionFromAscendingRailShape(shape);
        boolean ySlope = (Boolean)state.getValue((Property)FramedProperties.Y_SLOPE);
        return (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLOPE.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope));
    }

    public static FramedRailSlopeGeometry normal(GeometryFactory.Context ctx) {
        return new FramedRailSlopeGeometry(ctx, Blocks.RAIL.defaultBlockState(), (EnumProperty<RailShape>)BlockStateProperties.RAIL_SHAPE);
    }

    public static FramedRailSlopeGeometry powered(GeometryFactory.Context ctx) {
        boolean powered = (Boolean)ctx.state().getValue((Property)BlockStateProperties.POWERED);
        return new FramedRailSlopeGeometry(ctx, (BlockState)Blocks.POWERED_RAIL.defaultBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(powered)), (EnumProperty<RailShape>)BlockStateProperties.RAIL_SHAPE_STRAIGHT);
    }

    public static FramedRailSlopeGeometry detector(GeometryFactory.Context ctx) {
        boolean powered = (Boolean)ctx.state().getValue((Property)BlockStateProperties.POWERED);
        return new FramedRailSlopeGeometry(ctx, (BlockState)Blocks.DETECTOR_RAIL.defaultBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(powered)), (EnumProperty<RailShape>)BlockStateProperties.RAIL_SHAPE_STRAIGHT);
    }

    public static FramedRailSlopeGeometry activator(GeometryFactory.Context ctx) {
        boolean powered = (Boolean)ctx.state().getValue((Property)BlockStateProperties.POWERED);
        return new FramedRailSlopeGeometry(ctx, (BlockState)Blocks.ACTIVATOR_RAIL.defaultBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(powered)), (EnumProperty<RailShape>)BlockStateProperties.RAIL_SHAPE_STRAIGHT);
    }
}

