/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.prism;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.TranslatedItemModelInfo;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.DirectionAxis;

public class FramedPrismGeometry
extends Geometry {
    private final Direction facing;
    private final Direction.Axis axis;
    private final boolean ySlope;

    public FramedPrismGeometry(GeometryFactory.Context ctx) {
        DirectionAxis dirAxis = (DirectionAxis)((Object)ctx.state().getValue(PropertyHolder.FACING_AXIS));
        this.facing = dirAxis.direction();
        this.axis = dirAxis.axis();
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        boolean quadOnFacingAxis;
        boolean yFacing = Utils.isY(this.facing);
        boolean yAxis = this.axis == Direction.Axis.Y;
        Direction quadFace = quad.getDirection();
        boolean quadOnAxis = quadFace.getAxis() == this.axis;
        boolean bl = quadOnFacingAxis = quadFace.getAxis() == this.facing.getAxis();
        if (!this.ySlope && yFacing && !quadOnAxis && !quadOnFacingAxis) {
            boolean up = this.facing == Direction.UP;
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!up, 0.5f)).apply(Modifiers.makeVerticalSlope(up, 45.0f)).export(quadMap.get(null));
        } else if (this.ySlope && yFacing && Utils.isY(quadFace)) {
            Direction onAxis = Direction.fromAxisAndDirection((Direction.Axis)this.axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            Direction offAxisCW = onAxis.getClockWise();
            Direction offAxisCCW = onAxis.getCounterClockWise();
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(offAxisCW, 0.5f)).apply(Modifiers.makeVerticalSlope(offAxisCCW, 45.0f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(offAxisCCW, 0.5f)).apply(Modifiers.makeVerticalSlope(offAxisCW, 45.0f)).export(quadMap.get(null));
        } else if (!yFacing && yAxis && !quadOnAxis && !quadOnFacingAxis) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.facing, 0.5f)).apply(Modifiers.makeHorizontalSlope(quadFace == this.facing.getCounterClockWise(), 45.0f)).export(quadMap.get(null));
        } else if (!(this.ySlope || yFacing || yAxis || quadFace != this.facing)) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.makeVerticalSlope(false, 45.0f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.makeVerticalSlope(true, 45.0f)).export(quadMap.get(null));
        } else if (this.ySlope && !yFacing && !yAxis && Utils.isY(quadFace)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing, 0.5f)).apply(Modifiers.makeVerticalSlope(this.facing, 45.0f)).export(quadMap.get(null));
        } else if (quadFace.getAxis() == this.axis) {
            QuadModifier.of(quad).apply(Modifiers.cutSmallTriangle(this.facing)).export(quadMap.get(quadFace));
        }
    }

    @Override
    public ItemModelInfo getItemModelInfo() {
        return TranslatedItemModelInfo.HAND_Y_HALF_UP;
    }
}

