/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pane;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.TranslatedItemModelInfo;
import xfacthd.framedblocks.api.util.Utils;

public class FramedWallBoardGeometry
extends Geometry {
    private static final TranslatedItemModelInfo ITEM_MODEL_INFO = TranslatedItemModelInfo.handOrGui(0.0f, 0.0f, -0.5f);
    private static final float DEPTH = 0.0625f;
    private final Direction dir;

    public FramedWallBoardGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (quadDir == this.dir.getOpposite()) {
            QuadModifier.of(quad).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
        } else if (Utils.isY(quadDir)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.0625f)).export(quadMap.get(quadDir));
        } else if (quadDir != this.dir) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.0625f)).export(quadMap.get(quadDir));
        }
    }

    @Override
    public ItemModelInfo getItemModelInfo() {
        return ITEM_MODEL_INFO;
    }
}

