/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.interactive;

import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedItemFrameGeometry
extends Geometry {
    private static final int GLOWING_BRIGHTNESS = 5;
    private final BlockState state;
    private final BakedModel baseModel;
    private final Direction facing;
    private final boolean leather;
    private final boolean mapFrame;
    private final boolean glowing;
    private final float innerLength;
    private final float innerPos;
    private final float innerMin;
    private final float innerMax;
    private final float outerMin;
    private final float outerMax;

    private FramedItemFrameGeometry(GeometryFactory.Context ctx, boolean glowing) {
        this.state = ctx.state();
        this.baseModel = ctx.baseModel();
        this.facing = (Direction)ctx.state().getValue((Property)BlockStateProperties.FACING);
        this.leather = (Boolean)ctx.state().getValue((Property)PropertyHolder.LEATHER);
        this.mapFrame = (Boolean)ctx.state().getValue((Property)PropertyHolder.MAP_FRAME);
        this.glowing = glowing;
        this.innerLength = this.mapFrame ? 0.9375f : 0.8125f;
        this.innerPos = this.mapFrame ? 0.0625f : 0.1875f;
        this.innerMin = this.mapFrame ? 0.0625f : 0.1875f;
        this.innerMax = this.mapFrame ? 0.9375f : 0.8125f;
        this.outerMin = this.mapFrame ? 0.0f : 0.125f;
        this.outerMax = this.mapFrame ? 1.0f : 0.875f;
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadFace = quad.getDirection();
        if (Utils.isY(this.facing)) {
            this.makeVerticalFrame(quadMap, quad, quadFace);
        } else {
            this.makeHorizontalFrame(quadMap, quad, quadFace);
        }
    }

    private void makeVerticalFrame(QuadMap quadMap, BakedQuad quad, Direction quadFace) {
        if (quadFace == this.facing) {
            QuadModifier.of(quad).applyIf(Modifiers.cutTopBottom(this.outerMin, this.outerMin, this.outerMax, this.outerMax), !this.mapFrame).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).export(quadMap.get(quadFace));
        } else if (quadFace == this.facing.getOpposite()) {
            if (!this.leather && !this.mapFrame) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.innerMin, this.innerMin, this.innerMax, this.innerMax)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.03125f)).export(quadMap.get(null));
            }
            if (!this.mapFrame || this.leather) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.outerMin, this.outerMin, this.innerMin, this.outerMax)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.innerMax, this.outerMin, this.outerMax, this.outerMax)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.innerMin, this.outerMin, this.innerMax, this.innerMin)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.innerMin, this.innerMax, this.innerMax, this.outerMax)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
            }
            if (this.mapFrame && !this.leather) {
                QuadModifier.of(quad).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(quadFace));
            }
        } else {
            boolean down = this.facing == Direction.UP;
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(down, 0.0625f)).applyIf(Modifiers.cutSideLeftRight(this.outerMax), !this.mapFrame).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).applyIf(Modifiers.setPosition(this.outerMax), !this.mapFrame).export(quadMap.get(null));
            if (!this.mapFrame) {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!down, 0.96875f)).apply(Modifiers.cutSideUpDown(down, 0.0625f)).apply(Modifiers.cutSideLeftRight(this.innerLength)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(this.innerPos)).export(quadMap.get(null));
            }
        }
    }

    private void makeHorizontalFrame(QuadMap quadMap, BakedQuad quad, Direction quadFace) {
        if (quadFace == this.facing) {
            QuadModifier.of(quad).applyIf(Modifiers.cutSide(this.outerMin, this.outerMin, this.outerMax, this.outerMax), !this.mapFrame).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).export(quadMap.get(quadFace));
        } else if (quadFace == this.facing.getOpposite()) {
            if (!this.leather && !this.mapFrame) {
                QuadModifier.of(quad).apply(Modifiers.cutSide(this.innerMin, this.innerMin, this.innerMax, this.innerMax)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.03125f)).export(quadMap.get(null));
            }
            if (!this.mapFrame || this.leather) {
                QuadModifier.of(quad).apply(Modifiers.cutSide(this.outerMin, this.outerMin, this.innerMin, this.outerMax)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutSide(this.innerMax, this.outerMin, this.outerMax, this.outerMax)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutSide(this.innerMin, this.outerMin, this.innerMax, this.innerMin)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutSide(this.innerMin, this.innerMax, this.innerMax, this.outerMax)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
            }
            if (this.mapFrame && !this.leather) {
                QuadModifier.of(quad).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(quadFace));
            }
        } else if (Utils.isY(quadFace)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing.getOpposite(), 0.0625f)).applyIf(Modifiers.cutTopBottom(this.facing.getClockWise().getAxis(), this.outerMax), !this.mapFrame).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).applyIf(Modifiers.setPosition(this.outerMax), !this.mapFrame).export(quadMap.get(null));
            if (!this.mapFrame) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing, 0.96875f)).apply(Modifiers.cutTopBottom(this.facing.getOpposite(), 0.0625f)).apply(Modifiers.cutTopBottom(this.facing.getClockWise().getAxis(), this.innerLength)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(this.innerPos)).export(quadMap.get(null));
            }
        } else {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.facing.getOpposite(), 0.0625f)).applyIf(Modifiers.cutSideUpDown(this.outerMax), !this.mapFrame).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).applyIf(Modifiers.setPosition(this.outerMax), !this.mapFrame).export(quadMap.get(null));
            if (!this.mapFrame) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.facing, 0.96875f)).apply(Modifiers.cutSideLeftRight(this.facing.getOpposite(), 0.0625f)).apply(Modifiers.cutSideUpDown(this.innerLength)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(this.innerPos)).export(quadMap.get(null));
            }
        }
    }

    @Override
    public ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        if (this.leather) {
            return ModelUtils.SOLID;
        }
        return ChunkRenderTypeSet.none();
    }

    @Override
    public void getAdditionalQuads(QuadMap quadMap, RandomSource rand, ModelData data, RenderType renderType) {
        if (this.leather) {
            List quads = this.baseModel.getQuads(this.state, null, rand, data, renderType);
            for (BakedQuad quad : quads) {
                if (ClientUtils.isDummyTexture(quad)) continue;
                if (this.glowing) {
                    QuadModifier.of(quad).apply(Modifiers.applyLightmap(5, 0)).modifyInPlace();
                }
                quadMap.get(null).add(quad);
            }
        }
    }

    public static FramedItemFrameGeometry normal(GeometryFactory.Context ctx) {
        return new FramedItemFrameGeometry(ctx, false);
    }

    public static FramedItemFrameGeometry glowing(GeometryFactory.Context ctx) {
        return new FramedItemFrameGeometry(ctx, true);
    }
}

