/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.cube;

import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.ChestState;
import xfacthd.framedblocks.common.data.property.LatchType;

public class FramedChestGeometry
extends Geometry {
    private final BlockState state;
    private final BakedModel baseModel;
    private final Direction facing;
    private final boolean closed;
    private final LatchType latch;
    private final ChunkRenderTypeSet addLayers;

    public FramedChestGeometry(GeometryFactory.Context ctx) {
        this.state = ctx.state();
        this.baseModel = ctx.baseModel();
        this.facing = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.closed = ctx.state().getValue(PropertyHolder.CHEST_STATE) == ChestState.CLOSED || ClientUtils.OPTIFINE_LOADED.get() != false;
        this.latch = (LatchType)((Object)ctx.state().getValue(PropertyHolder.LATCH_TYPE));
        this.addLayers = this.latch == LatchType.DEFAULT ? ModelUtils.CUTOUT : ChunkRenderTypeSet.none();
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quad.getDirection())) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.0625f, 0.0625f, 0.9375f, 0.9375f)).applyIf(Modifiers.setPosition(this.closed ? 0.875f : 0.625f), quadDir == Direction.UP).export(quadMap.get(quadDir == Direction.UP ? null : quadDir));
        } else {
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.0625f, 0.0f, 0.9375f, this.closed ? 0.875f : 0.625f)).apply(Modifiers.setPosition(0.9375f)).export(quadMap.get(null));
        }
        if (this.latch == LatchType.CAMO && this.closed) {
            FramedChestGeometry.makeChestLatch(quadMap, quad, this.facing);
        }
    }

    public static void makeChestLatch(QuadMap quadMap, BakedQuad quad, Direction facing) {
        Direction face = quad.getDirection();
        if (face == facing || face == facing.getOpposite()) {
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.4375f, 0.4375f, 0.5625f, 0.6875f)).applyIf(Modifiers.setPosition(0.0625f), face != facing).export(quadMap.get((Direction)(face == facing ? facing : null)));
        } else if (Utils.isY(face)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(facing.getOpposite(), 0.0625f)).apply(Modifiers.cutTopBottom(facing.getClockWise(), 0.5625f)).apply(Modifiers.cutTopBottom(facing.getCounterClockWise(), 0.5625f)).apply(Modifiers.setPosition(face == Direction.UP ? 0.6875f : 0.5625f)).export(quadMap.get(null));
        } else {
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.0f, 0.4375f, 1.0f, 0.6875f)).apply(Modifiers.cutSideLeftRight(facing.getOpposite(), 0.0625f)).apply(Modifiers.setPosition(0.5625f)).export(quadMap.get(null));
        }
    }

    @Override
    public ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return this.addLayers;
    }

    @Override
    public void getAdditionalQuads(QuadMap quadMap, RandomSource rand, ModelData data, RenderType renderType) {
        if (!this.closed || this.latch != LatchType.DEFAULT) {
            return;
        }
        List quads = this.baseModel.getQuads(this.state, null, rand, data, renderType);
        for (BakedQuad quad : quads) {
            quadMap.get(null).add(quad);
        }
    }
}

