/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.math.Transformation;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.util.Utils;

public final class FluidModel
implements BakedModel {
    private static final ModelState SIMPLE_STATE = new SimpleModelState(Transformation.identity());
    public static final ModelResourceLocation BARE_MODEL = ModelResourceLocation.standalone((ResourceLocation)Utils.rl("fluid/bare"));
    private static final Function<ResourceLocation, TextureAtlasSprite> SPRITE_GETTER = loc -> (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(loc);
    private static final Supplier<ResourceLocation> WATER_STILL = Suppliers.memoize(() -> IClientFluidTypeExtensions.of((Fluid)Fluids.WATER).getStillTexture());
    private static final Supplier<ResourceLocation> WATER_FLOWING = Suppliers.memoize(() -> IClientFluidTypeExtensions.of((Fluid)Fluids.WATER).getFlowingTexture());
    private final RenderType fluidLayer;
    private final ChunkRenderTypeSet fluidLayerSet;
    private final Map<Direction, List<BakedQuad>> quads;
    private final TextureAtlasSprite particles;

    private FluidModel(RenderType fluidLayer, Map<Direction, List<BakedQuad>> quads, TextureAtlasSprite particles) {
        this.fluidLayer = fluidLayer;
        this.fluidLayerSet = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{fluidLayer});
        this.quads = quads;
        this.particles = particles;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource random) {
        return this.getQuads(state, side, random, ModelData.EMPTY, RenderType.translucent());
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, RenderType layer) {
        if (side == null || layer != this.fluidLayer) {
            return Collections.emptyList();
        }
        return this.quads.get(side);
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return this.fluidLayerSet;
    }

    public boolean useAmbientOcclusion() {
        return false;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.particles;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public static FluidModel create(Fluid fluid) {
        ModelBakery modelBakery = Minecraft.getInstance().getModelManager().getModelBakery();
        UnbakedModel bareModel = modelBakery.getModel(BARE_MODEL.id());
        Preconditions.checkNotNull((Object)bareModel, (Object)"Bare fluid model not loaded!");
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidName = (ResourceLocation)Preconditions.checkNotNull((Object)NeoForgeRegistries.FLUID_TYPES.getKey((Object)fluid.getFluidType()), (Object)"Cannot create FluidModel for unregistered FluidType");
        ModelResourceLocation modelName = new ModelResourceLocation(Utils.rl("fluid/" + fluidName.toString().replace(":", "_")), "framedblocks_dynamic_fluid");
        Function<Material, TextureAtlasSprite> spriteGetter = FluidModel.matToSprite(props);
        ModelBakery modelBakery2 = modelBakery;
        Objects.requireNonNull(modelBakery2);
        BakedModel model = bareModel.bake((ModelBaker)new ModelBakery.ModelBakerImpl(modelBakery2, (modelLoc, material) -> (TextureAtlasSprite)spriteGetter.apply(material), modelName), spriteGetter, SIMPLE_STATE);
        Preconditions.checkNotNull((Object)model, (Object)"Failed to bake fluid model");
        EnumMap<Direction, List<BakedQuad>> quads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        BlockState defState = fluid.defaultFluidState().createLegacyBlock();
        RandomSource random = RandomSource.create();
        RenderType layer = ItemBlockRenderTypes.getRenderLayer((FluidState)fluid.defaultFluidState());
        for (Direction side : Direction.values()) {
            quads.put(side, model.getQuads(defState, side, random, ModelData.EMPTY, layer));
        }
        return new FluidModel(layer, quads, SPRITE_GETTER.apply(props.getStillTexture()));
    }

    private static Function<Material, TextureAtlasSprite> matToSprite(IClientFluidTypeExtensions props) {
        return mat -> {
            if (mat.texture().equals((Object)WATER_FLOWING.get())) {
                return SPRITE_GETTER.apply(props.getFlowingTexture());
            }
            if (mat.texture().equals((Object)WATER_STILL.get())) {
                return SPRITE_GETTER.apply(props.getStillTexture());
            }
            return mat.sprite();
        };
    }
}

