/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.apiimpl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import xfacthd.framedblocks.api.FramedBlocksClientAPI;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.data.ConTexDataHandler;
import xfacthd.framedblocks.client.model.QuadTable;
import xfacthd.framedblocks.client.overlaygen.OverlayQuadGenerator;
import xfacthd.framedblocks.client.render.color.FramedBlockColor;

public final class ClientApiImpl
implements FramedBlocksClientAPI {
    @Override
    public BlockColor defaultBlockColor() {
        return FramedBlockColor.INSTANCE;
    }

    @Override
    public void addConTexProperty(ModelProperty<?> ctProperty) {
        ConTexDataHandler.addConTexProperty(ctProperty);
    }

    @Override
    public void generateOverlayQuads(QuadMap quadMap, Direction side, TextureAtlasSprite sprite) {
        this.generateOverlayQuads(quadMap, side, sprite, (Direction dir) -> true);
    }

    @Override
    public void generateOverlayQuads(QuadMap quadMap, Direction side, TextureAtlasSprite sprite, Predicate<Direction> filter) {
        this.generateOverlayQuads(quadMap, side, (Direction dir) -> sprite, filter);
    }

    @Override
    public void generateOverlayQuads(QuadMap quadMap, Direction side, Function<Direction, TextureAtlasSprite> spriteGetter, Predicate<Direction> filter) {
        QuadTable quadTable = (QuadTable)quadMap;
        List<BakedQuad> allQuads = quadTable.getAllQuads(side);
        if (allQuads.isEmpty()) {
            return;
        }
        List<BakedQuad> generatedQuads = OverlayQuadGenerator.generate(allQuads, spriteGetter, filter);
        if (generatedQuads.isEmpty()) {
            return;
        }
        ArrayList<BakedQuad> existingQuads = quadTable.get(side);
        ArrayList<BakedQuad> targetQuads = new ArrayList<BakedQuad>(existingQuads.size() + generatedQuads.size());
        Utils.copyAll(existingQuads, targetQuads);
        Utils.copyAll(generatedQuads, targetQuads);
        quadTable.put(side, targetQuads);
    }
}

