/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util;

import com.google.common.base.Preconditions;
import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredItem;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.empty.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.api.util.registration.DeferredDataComponentType;

public final class Utils {
    private static final ResourceLocation RL_TEMPLATE = Utils.rl("framedblocks", "");
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final Direction[] HORIZONTAL_DIRECTIONS = (Direction[])Direction.Plane.HORIZONTAL.stream().toArray(Direction[]::new);
    public static final TagKey<Block> FRAMEABLE = Utils.blockTag("frameable");
    public static final TagKey<Block> BLOCK_BLACKLIST = Utils.blockTag("blacklisted");
    public static final TagKey<Fluid> FLUID_BLACKLIST = TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)Utils.rl("blacklisted"));
    public static final TagKey<Block> BE_WHITELIST = Utils.blockTag("blockentity_whitelisted");
    public static final TagKey<Item> TOOL_WRENCH = Utils.itemTag("c", "tools/wrench");
    public static final ItemAbility ACTION_WRENCH = ItemAbility.get((String)"wrench");
    public static final TagKey<Item> DISABLE_INTANGIBLE = Utils.itemTag("disable_intangible");
    public static final Set<Property<?>> REQUIRED_STATE_PROPERTIES = Set.of(FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT);
    public static final Holder<Item> FRAMED_HAMMER = DeferredItem.createItem((ResourceLocation)Utils.rl("framed_hammer"));
    public static final Holder<Item> FRAMED_WRENCH = DeferredItem.createItem((ResourceLocation)Utils.rl("framed_wrench"));
    public static final Holder<Item> FRAMED_KEY = DeferredItem.createItem((ResourceLocation)Utils.rl("framed_key"));
    public static final Holder<Item> FRAMED_SCREWDRIVER = DeferredItem.createItem((ResourceLocation)Utils.rl("framed_screwdriver"));
    public static final Holder<Item> FRAMED_REINFORCEMENT = DeferredItem.createItem((ResourceLocation)Utils.rl("framed_reinforcement"));
    public static final DeferredDataComponentType<CamoList> DC_TYPE_CAMO_LIST = DeferredDataComponentType.createDataComponent(Utils.rl("camo_list"));
    private static final Long2ObjectMap<Direction> DIRECTION_BY_NORMAL = (Long2ObjectMap)Arrays.stream(Direction.values()).collect(Collectors.toMap(side -> new BlockPos(side.getNormal()).asLong(), Function.identity(), (sideA, sideB) -> {
        throw new IllegalArgumentException("Duplicate keys");
    }, Long2ObjectOpenHashMap::new));

    public static Vec3 fraction(Vec3 vec) {
        return new Vec3(vec.x() - Math.floor(vec.x()), vec.y() - Math.floor(vec.y()), vec.z() - Math.floor(vec.z()));
    }

    public static double fractionInDir(Vec3 vec, Direction dir) {
        double coord = switch (dir.getAxis()) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> vec.x;
            case Direction.Axis.Y -> vec.y;
            case Direction.Axis.Z -> vec.z;
        };
        coord -= Math.floor(coord);
        return Utils.isPositive(dir) ? coord : 1.0 - coord;
    }

    public static boolean isLower(float lhs, float rhs) {
        if (Mth.equal((float)lhs, (float)rhs)) {
            return false;
        }
        return lhs < rhs;
    }

    public static boolean isHigher(float lhs, float rhs) {
        if (Mth.equal((float)lhs, (float)rhs)) {
            return false;
        }
        return lhs > rhs;
    }

    public static long lcm(int a, int b) {
        return (long)a * (long)(b / IntMath.gcd((int)a, (int)b));
    }

    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createBlockEntityTicker(BlockEntityType<A> type, BlockEntityType<E> actualType, BlockEntityTicker<? super E> ticker) {
        return actualType == type ? ticker : null;
    }

    public static MutableComponent translate(String prefix, String postfix, Object ... arguments) {
        return Component.translatable((String)Utils.translationKey(prefix, postfix), (Object[])arguments);
    }

    public static MutableComponent translate(String prefix, String postfix) {
        return Component.translatable((String)Utils.translationKey(prefix, postfix));
    }

    public static String translationKey(String prefix, String postfix) {
        Object key = "";
        if (prefix != null) {
            key = prefix + ".";
        }
        key = (String)key + "framedblocks";
        if (postfix != null) {
            key = (String)key + "." + postfix;
        }
        return key;
    }

    public static String translateConfig(String type, String key) {
        return Utils.translationKey("config", type + "." + key);
    }

    public static <T extends Enum<T>> Component[] buildEnumTranslations(String prefix, String postfix, T[] values, ChatFormatting ... formatting) {
        return (Component[])Arrays.stream(values).map(v -> Utils.translate(prefix, postfix + "." + ((StringRepresentable)v).getSerializedName())).map(c -> c.withStyle(formatting)).toArray(Component[]::new);
    }

    public static <T extends Enum<T>> Component[] bindEnumTranslation(String key, T[] values, Component[] valueTranslations) {
        Preconditions.checkArgument((values.length == valueTranslations.length ? 1 : 0) != 0, (Object)"Value and translation arrays must have the same length");
        Component[] components = new Component[values.length];
        for (T v : values) {
            components[((Enum)v).ordinal()] = Component.translatable((String)key, (Object[])new Object[]{valueTranslations[((Enum)v).ordinal()]});
        }
        return components;
    }

    public static MutableComponent translateTag(TagKey<?> tag) {
        String key = Tags.getTagTranslationKey(tag);
        return Component.translatableWithFallback((String)key, (String)("#" + String.valueOf(tag.location())));
    }

    public static boolean isPositive(Direction dir) {
        return dir.getAxisDirection() == Direction.AxisDirection.POSITIVE;
    }

    public static boolean isX(Direction dir) {
        return dir.getAxis() == Direction.Axis.X;
    }

    public static boolean isY(Direction dir) {
        return dir.getAxis() == Direction.Axis.Y;
    }

    public static boolean isZ(Direction dir) {
        return dir.getAxis() == Direction.Axis.Z;
    }

    public static Direction dirByNormal(int x, int y, int z) {
        return (Direction)DIRECTION_BY_NORMAL.get(BlockPos.asLong((int)x, (int)y, (int)z));
    }

    public static Direction dirByNormal(BlockPos from, BlockPos to) {
        int nx = to.getX() - from.getX();
        int ny = to.getY() - from.getY();
        int nz = to.getZ() - from.getZ();
        return Utils.dirByNormal(nx, ny, nz);
    }

    public static Direction.Axis nextAxisNotEqualTo(Direction.Axis axis, Direction.Axis except) {
        Direction.Axis[] axes = Direction.Axis.VALUES;
        while ((axis = axes[(axis.ordinal() + 1) % axes.length]) == except) {
        }
        return axis;
    }

    public static BlockState mirrorFaceBlock(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, FramedProperties.FACING_HOR, mirror);
    }

    public static BlockState mirrorFaceBlock(BlockState state, DirectionProperty property, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction dir = (Direction)state.getValue((Property)property);
        if (mirror == Mirror.FRONT_BACK && Utils.isX(dir) || mirror == Mirror.LEFT_RIGHT && Utils.isZ(dir)) {
            return (BlockState)state.setValue((Property)property, (Comparable)dir.getOpposite());
        }
        return state;
    }

    public static BlockState mirrorCornerBlock(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, FramedProperties.FACING_HOR, mirror);
    }

    public static BlockState mirrorCornerBlock(BlockState state, DirectionProperty property, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction dir = (Direction)state.getValue((Property)property);
        if (Utils.isY(dir)) {
            return state;
        }
        if (mirror == Mirror.LEFT_RIGHT) {
            dir = switch (dir) {
                case Direction.NORTH -> Direction.WEST;
                case Direction.EAST -> Direction.SOUTH;
                case Direction.SOUTH -> Direction.EAST;
                case Direction.WEST -> Direction.NORTH;
                default -> throw new IllegalArgumentException("Unreachable!");
            };
        } else {
            dir = switch (dir) {
                case Direction.NORTH -> Direction.EAST;
                case Direction.EAST -> Direction.NORTH;
                case Direction.SOUTH -> Direction.WEST;
                case Direction.WEST -> Direction.SOUTH;
                default -> throw new IllegalArgumentException("Unreachable!");
            };
        }
        return (BlockState)state.setValue((Property)property, (Comparable)dir);
    }

    public static <T> List<T> concat(List<T> listOne, List<T> listTwo) {
        ArrayList<T> list = new ArrayList<T>(listOne.size() + listTwo.size());
        list.addAll(listOne);
        list.addAll(listTwo);
        return List.copyOf(list);
    }

    public static <T> Set<T> concat(Set<T> setOne, Set<T> setTwo) {
        HashSet<T> set = new HashSet<T>(setOne.size() + setTwo.size());
        set.addAll(setOne);
        set.addAll(setTwo);
        return Set.copyOf(set);
    }

    public static <T> ArrayList<T> copyAll(List<T> src, ArrayList<T> dest) {
        dest.ensureCapacity(dest.size() + src.size());
        for (int i = 0; i < src.size(); ++i) {
            dest.add(src.get(i));
        }
        return dest;
    }

    public static <T> ArrayList<T> copyAllWithModifier(List<T> src, ArrayList<T> dest, UnaryOperator<T> modifier) {
        dest.ensureCapacity(dest.size() + src.size());
        for (int i = 0; i < src.size(); ++i) {
            dest.add(modifier.apply(src.get(i)));
        }
        return dest;
    }

    public static TagKey<Block> blockTag(String name) {
        return Utils.blockTag("framedblocks", name);
    }

    public static TagKey<Block> blockTag(String modid, String name) {
        return BlockTags.create((ResourceLocation)Utils.rl(modid, name));
    }

    public static TagKey<Item> itemTag(String name) {
        return Utils.itemTag("framedblocks", name);
    }

    public static TagKey<Item> itemTag(String modid, String name) {
        return ItemTags.create((ResourceLocation)Utils.rl(modid, name));
    }

    public static Property<?> getRotatableProperty(BlockState state) {
        for (Property prop : state.getProperties()) {
            if (prop.getValueClass() == Direction.Axis.class) {
                return prop;
            }
            if (!(prop instanceof DirectionProperty)) continue;
            return prop;
        }
        return null;
    }

    public static <T extends Comparable<T>> T tryGetValue(BlockState state, Property<T> property, T _default) {
        return (T)(state.hasProperty(property) ? state.getValue(property) : _default);
    }

    public static void addRequiredProperties(StateDefinition.Builder<Block, BlockState> builder) {
        REQUIRED_STATE_PROPERTIES.forEach(xva$0 -> builder.add(new Property[]{xva$0}));
    }

    public static BlockState copyRequiredProperties(BlockState from, BlockState to) {
        for (Property<?> property : REQUIRED_STATE_PROPERTIES) {
            to = Block.copyProperty((BlockState)from, (BlockState)to, property);
        }
        return to;
    }

    public static void forAllDirections(Consumer<Direction> consumer) {
        Utils.forAllDirections(true, consumer);
    }

    public static void forAllDirections(boolean includeNull, Consumer<Direction> consumer) {
        if (includeNull) {
            consumer.accept(null);
        }
        for (Direction dir : DIRECTIONS) {
            consumer.accept(dir);
        }
    }

    public static void forHorizontalDirections(Consumer<Direction> consumer) {
        for (Direction dir : HORIZONTAL_DIRECTIONS) {
            consumer.accept(dir);
        }
    }

    public static int maskNullDirection(Direction dir) {
        return dir == null ? DIRECTIONS.length : dir.ordinal();
    }

    public static void wrapInStateCopy(LevelAccessor level, BlockPos pos, Player player, ItemStack stack, boolean writeToCamoTwo, boolean consumeItem, Runnable action) {
        FramedBlockEntity be;
        CamoContainer camo = EmptyCamoContainer.EMPTY;
        boolean glowing = false;
        boolean intangible = false;
        boolean reinforced = false;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            be = (FramedBlockEntity)blockEntity;
            camo = be.getCamo();
            glowing = be.isGlowing();
            intangible = be.isIntangible(null);
            reinforced = be.isReinforced();
        }
        action.run();
        if (consumeItem && !player.isCreative()) {
            stack.shrink(1);
            player.getInventory().setChanged();
        }
        if ((blockEntity = level.getBlockEntity(pos)) instanceof FramedBlockEntity) {
            be = (FramedBlockEntity)blockEntity;
            be.setCamo(camo, writeToCamoTwo);
            be.setGlowing(glowing);
            be.setIntangible(intangible);
            be.setReinforced(reinforced);
        }
    }

    public static ResourceLocation rl(String path) {
        return RL_TEMPLATE.withPath(path);
    }

    public static ResourceLocation rl(String namespace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static <T extends CustomPacketPayload> CustomPacketPayload.Type<T> payloadType(String path) {
        return new CustomPacketPayload.Type(Utils.rl(path));
    }

    public static <T> ResourceKey<T> getKeyOrThrow(Holder<T> holder) {
        return (ResourceKey)holder.unwrapKey().orElseThrow(() -> new IllegalArgumentException("Direct holders and unbound reference holders are not supported"));
    }

    public static boolean isHandContext(ItemDisplayContext ctx) {
        return ctx.firstPerson() || ctx == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || ctx == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
    }

    public static void giveToPlayer(Player player, ItemStack stack, boolean giveInSurvival) {
        if (stack.isEmpty()) {
            return;
        }
        boolean creative = player.isCreative();
        if (!creative && giveInSurvival) {
            if (!player.getInventory().add(stack)) {
                player.drop(stack, false);
            }
        } else if (creative && !player.getInventory().contains(stack)) {
            player.getInventory().add(stack);
        }
    }

    public static String formatItemStack(ItemStack stack) {
        if (stack.isEmpty()) {
            return "~~EMPTY~~";
        }
        String result = stack.getCount() + "x " + String.valueOf(stack.getItem()) + "[";
        DataComponentPatch patch = stack.getComponentsPatch();
        if (patch != DataComponentPatch.EMPTY) {
            result = result + String.valueOf(patch);
        }
        return result + "]";
    }

    public static String formatHitResult(@Nullable HitResult hitResult) {
        if (hitResult == null) {
            return "~~NULL~~";
        }
        ToStringBuilder result = new ToStringBuilder((Object)hitResult).append("Type", (Object)hitResult.getType()).append("Location", (Object)hitResult.getLocation());
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            result.append("Position", (Object)blockHit.getBlockPos()).append("Side", (Object)blockHit.getDirection()).append("Inside", blockHit.isInside());
        } else if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hitResult;
            result.append("Entity", (Object)entityHit.getEntity());
        }
        return result.toString();
    }

    @ApiStatus.Internal
    public static <T> T loadService(Class<T> clazz) {
        return ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
    }

    private Utils() {
    }
}

