/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.model;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.model.DataAwareItemModel;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.api.util.ConfigView;
import xfacthd.framedblocks.api.util.Utils;

public abstract class AbstractFramedBlockModel
extends BakedModelWrapper<BakedModel> {
    private final List<BakedModel> defaultItemRenderPass = List.of(this);
    private final BlockState state;
    private final ItemModelInfo itemModelInfo;
    private final boolean dataRequired;
    private final Map<CamoList, List<BakedModel>> itemModelCache;

    protected AbstractFramedBlockModel(BakedModel baseModel, BlockState state, ItemModelInfo itemModelInfo) {
        super(baseModel);
        IFramedBlock block;
        this.state = state;
        Block block2 = state.getBlock();
        boolean isItemModel = block2 instanceof IFramedBlock && (block = (IFramedBlock)block2).getItemModelSource() == state;
        this.itemModelInfo = isItemModel ? itemModelInfo : null;
        this.dataRequired = isItemModel && itemModelInfo.isDataRequired();
        this.itemModelCache = isItemModel ? new ConcurrentHashMap() : null;
    }

    public BakedModel applyTransform(ItemDisplayContext ctx, PoseStack poseStack, boolean leftHand) {
        super.applyTransform(ctx, poseStack, leftHand);
        if (this.itemModelInfo != null) {
            this.itemModelInfo.applyItemTransform(poseStack, ctx, leftHand);
        }
        return this;
    }

    public List<BakedModel> getRenderPasses(ItemStack stack, boolean cull) {
        CamoList camos;
        boolean showCamo = ConfigView.Client.INSTANCE.shouldRenderItemModelsWithCamo();
        if (this.itemModelInfo == null || !this.dataRequired && !showCamo) {
            return this.defaultItemRenderPass;
        }
        CamoList camoList = camos = showCamo ? (CamoList)stack.getOrDefault(Utils.DC_TYPE_CAMO_LIST, (Object)CamoList.EMPTY) : CamoList.EMPTY;
        if (!this.dataRequired && camos.isEmpty()) {
            return this.defaultItemRenderPass;
        }
        List<BakedModel> models = this.itemModelCache.get(camos);
        if (models == null) {
            ModelData data = this.itemModelInfo.buildItemModelData(this.state, camos);
            models = new ArrayList<BakedModel>();
            for (RenderType renderType : this.getRenderTypes(this.state, RandomSource.create(), data)) {
                models.add((BakedModel)new DataAwareItemModel((BakedModel)this, data, renderType, cull));
            }
            this.itemModelCache.put(camos, models);
        }
        return models;
    }

    public void clearCache() {
        if (this.itemModelCache != null) {
            this.itemModelCache.clear();
        }
    }
}

