/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.camo;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xfacthd.framedblocks.api.FramedBlocksAPI;
import xfacthd.framedblocks.api.camo.CamoClientHandler;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.CamoContainerFactory;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.api.camo.CamoResolvingLevelReader;
import xfacthd.framedblocks.api.camo.empty.EmptyCamoContainer;
import xfacthd.framedblocks.api.internal.InternalAPI;

public final class CamoContainerHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Registry<CamoContainerFactory<?>> REGISTRY = FramedBlocksAPI.INSTANCE.getCamoContainerFactoryRegistry();
    public static final Codec<CamoContainer<?, ?>> CODEC = REGISTRY.byNameCodec().dispatch(CamoContainer::getFactory, CamoContainerFactory::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, CamoContainer<?, ?>> STREAM_CODEC = ByteBufCodecs.registry((ResourceKey)REGISTRY.key()).dispatch(CamoContainer::getFactory, CamoContainerFactory::streamCodec);

    public static Tag writeToDisk(CamoContainer<?, ?> camo) {
        return CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, camo).result().orElseGet(CompoundTag::new);
    }

    public static CamoContainer<?, ?> readFromDisk(CompoundTag tag) {
        if (tag.isEmpty()) {
            return EmptyCamoContainer.EMPTY;
        }
        return CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).ifError(err -> LOGGER.error(err.message())).result().map(Pair::getFirst).orElse(EmptyCamoContainer.EMPTY);
    }

    public static CompoundTag writeToNetwork(CamoContainer<?, ?> camo) {
        CamoContainerFactory<?> factory = camo.getFactory();
        int id = REGISTRY.getId(factory);
        Preconditions.checkState((id != -1 ? 1 : 0) != 0, (Object)"Attempted to get sync ID for unregistered CamoContainerFactory");
        CompoundTag tag = new CompoundTag();
        tag.putInt("type", REGISTRY.getId(factory));
        factory.writeToNetwork(tag, camo);
        return tag;
    }

    public static CamoContainer<?, ?> readFromNetwork(CompoundTag tag) {
        if (tag.isEmpty()) {
            return EmptyCamoContainer.EMPTY;
        }
        int id = tag.getInt("type");
        CamoContainerFactory factory = (CamoContainerFactory)REGISTRY.byId(id);
        if (factory == null) {
            LOGGER.error("Received unknown CamoContainer with ID {} from network, dropping!", (Object)id);
            return EmptyCamoContainer.EMPTY;
        }
        return factory.readFromNetwork(tag);
    }

    public static boolean validateCamo(CamoContainer<?, ?> camo) {
        CamoContainerFactory<?> factory = camo.getFactory();
        return factory.validateCamo(camo);
    }

    public static boolean removeCamo(CamoContainer<?, ?> camo, Level level, BlockPos pos, Player player, ItemStack stack) {
        CamoContainerFactory<?> factory = camo.getFactory();
        return factory.removeCamo(level, pos, player, stack, camo);
    }

    public static ItemStack dropCamo(CamoContainer<?, ?> camo) {
        CamoContainerFactory<?> factory = camo.getFactory();
        return factory.dropCamo(camo);
    }

    @Nullable
    public static CamoContainerFactory<?> findCamoFactory(ItemStack stack) {
        return InternalAPI.INSTANCE.findCamoFactory(stack);
    }

    public static boolean isValidRemovalTool(CamoContainer<?, ?> container, ItemStack stack) {
        return InternalAPI.INSTANCE.isValidRemovalTool(container, stack);
    }

    public static TriState canPlantSurviveOnCamo(BlockState camoState, BlockGetter level, BlockPos pos, Direction side, BlockState plant) {
        if (!camoState.isAir() && level instanceof LevelReader) {
            LevelReader reader = (LevelReader)level;
            BlockPos plantPos = pos.relative(side);
            if (reader instanceof CamoResolvingLevelReader) {
                LOGGER.warn("Encountered unexpected recursion in plant sustainability check for plant '{}' at {} on side {} of a framed block", new Object[]{plant, plantPos, side});
                return TriState.DEFAULT;
            }
            CamoResolvingLevelReader camoResolvingLevel = new CamoResolvingLevelReader(reader, plantPos);
            if (plant.canSurvive((LevelReader)camoResolvingLevel, plantPos)) {
                return TriState.TRUE;
            }
        }
        return TriState.DEFAULT;
    }

    private CamoContainerHelper() {
    }

    public static final class Client {
        public static BakedModel getOrCreateModel(CamoContent<?> content) {
            CamoClientHandler<?> clientHandler = content.getClientHandler();
            return clientHandler.getOrCreateModel(content);
        }

        public static ChunkRenderTypeSet getRenderTypes(CamoContent<?> content, RandomSource random, ModelData modelData) {
            CamoClientHandler<?> clientHandler = content.getClientHandler();
            return clientHandler.getRenderTypes(content, random, modelData);
        }

        private Client() {
        }
    }
}

