/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.extensions.IBlockExtension;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.block.cache.IStateCacheAccessor;
import xfacthd.framedblocks.api.block.cache.StateCache;
import xfacthd.framedblocks.api.block.render.CullingHelper;
import xfacthd.framedblocks.api.block.render.ParticleHelper;
import xfacthd.framedblocks.api.blueprint.BlueprintData;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.api.internal.InternalAPI;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.ConfigView;
import xfacthd.framedblocks.api.util.Utils;

public interface IFramedBlock
extends EntityBlock,
IBlockExtension {
    public static final String LOCK_MESSAGE = Utils.translationKey("msg", "lock_state");
    public static final Component STATE_LOCKED = Utils.translate("msg", "lock_state.locked").withStyle(ChatFormatting.RED);
    public static final Component STATE_UNLOCKED = Utils.translate("msg", "lock_state.unlocked").withStyle(ChatFormatting.GREEN);

    public IBlockType getBlockType();

    public static BlockBehaviour.Properties createProperties(IBlockType type) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).emissiveRendering(IFramedBlock::isEmissiveRendering).isViewBlocking(IFramedBlock::isBlockSuffocating).isSuffocating(IFramedBlock::isBlockSuffocating);
        if (!type.canOccludeWithSolidCamo()) {
            props.noOcclusion();
        }
        return props;
    }

    private static boolean isEmissiveRendering(BlockState state, BlockGetter level, BlockPos pos) {
        return ((IFramedBlock)state.getBlock()).isCamoEmissiveRendering(state, level, pos);
    }

    private static boolean isBlockSuffocating(BlockState state, BlockGetter level, BlockPos pos) {
        return ((IFramedBlock)state.getBlock()).isSuffocating(state, level, pos);
    }

    default public BlockItem createBlockItem() {
        return new BlockItem((Block)this, new Item.Properties());
    }

    @ApiStatus.OverrideOnly
    default public StateCache initCache(BlockState state) {
        return new StateCache(state, this.getBlockType());
    }

    default public StateCache getCache(BlockState state) {
        return ((IStateCacheAccessor)state).framedblocks$getCache();
    }

    default public void tryApplyCamoImmediately(Level level, BlockPos pos, @Nullable LivingEntity placer, ItemStack stack) {
        Player player;
        if (level.isClientSide()) {
            return;
        }
        if (stack.get(DataComponents.BLOCK_ENTITY_DATA) != null) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof FramedBlockEntity) {
                FramedBlockEntity be = (FramedBlockEntity)blockEntity;
                be.checkCamoSolid();
            }
            return;
        }
        if (placer instanceof Player && (player = (Player)placer).getMainHandItem() == stack) {
            FramedBlockEntity be;
            BlockItem item;
            ItemStack offhandStack = player.getOffhandItem();
            Item item2 = offhandStack.getItem();
            if (item2 instanceof BlockItem ? (item = (BlockItem)item2).getBlock() instanceof IFramedBlock : !offhandStack.is(Tags.Items.DUSTS_GLOWSTONE)) {
                return;
            }
            item2 = level.getBlockEntity(pos);
            if (item2 instanceof FramedBlockEntity && (be = (FramedBlockEntity)item2).canAutoApplyCamoOnPlacement()) {
                Vec3 hitVec = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                be.handleInteraction(player, InteractionHand.OFF_HAND, new BlockHitResult(hitVec, Direction.UP, pos, false));
            }
        }
    }

    default public ItemInteractionResult handleUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.getBlockType().canLockState() && hand == InteractionHand.MAIN_HAND && this.lockState(level, pos, player, player.getItemInHand(hand))) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (player.getItemInHand(hand).canPerformAction(Utils.ACTION_WRENCH)) {
            Rotation rot = player.isShiftKeyDown() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
            BlockState newState = this.rotate(state, hit, rot);
            if (newState != state) {
                if (!level.isClientSide()) {
                    level.setBlockAndUpdate(pos, newState);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            return ItemInteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.handleInteraction(player, hand, hit);
        }
        return ItemInteractionResult.FAIL;
    }

    default public boolean hasDynamicLightEmission(BlockState state) {
        return (Boolean)state.getValue((Property)FramedProperties.GLOWING);
    }

    default public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if (!((Boolean)state.getValue((Property)FramedProperties.GLOWING)).booleanValue()) {
            return 0;
        }
        AuxiliaryLightManager lightManager = level.getAuxLightManager(pos);
        if (lightManager != null) {
            return lightManager.getLightAt(pos);
        }
        return 0;
    }

    default public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            CamoContainer<?, ?> camo = be.getCamo();
            return ((CamoContent)camo.getContent()).getSoundType();
        }
        return state.getSoundType();
    }

    default public List<ItemStack> getCamoDrops(List<ItemStack> drops, LootParams.Builder builder) {
        Object object = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)((Object)object);
            be.addAdditionalDrops(drops, ConfigView.Server.INSTANCE.shouldConsumeCamoItem());
        }
        return drops;
    }

    @Nullable
    default public BlockState runOcclusionTestAndGetLookupState(SideSkipPredicate pred, BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (pred.test(level, pos, state, adjState, side)) {
            return adjState;
        }
        return null;
    }

    default public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        return InternalAPI.INSTANCE.getAppearance(this, state, (BlockGetter)level, pos, side, queryState, queryPos);
    }

    @Nullable
    default public BlockState getComponentAtEdge(BlockGetter level, BlockPos pos, BlockState state, Direction side, @Nullable Direction edge) {
        return state;
    }

    @Nullable
    default public BlockState getComponentBySkipPredicate(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction side) {
        return state;
    }

    default public ModelData unpackNestedModelData(ModelData data, BlockState state, BlockState componentState) {
        return data;
    }

    default public boolean shouldPreventNeighborCulling(BlockGetter level, BlockPos pos, BlockState state, BlockPos adjPos, BlockState adjState) {
        IFramedBlock adjBlock;
        if (!ConfigView.Server.INSTANCE.enableIntangibility()) {
            return false;
        }
        Block block = adjState.getBlock();
        if (block instanceof IFramedBlock && (adjBlock = (IFramedBlock)block).isIntangible(adjState, level, adjPos, null)) {
            return false;
        }
        return this.isIntangible(state, level, pos, null);
    }

    default public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getCamoFriction(state, entity, state.getBlock().getFriction());
        }
        return state.getBlock().getFriction();
    }

    default public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        FramedBlockEntity be;
        float resistance;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity && (resistance = (be = (FramedBlockEntity)blockEntity).getCamoExplosionResistance(explosion)) > 0.0f) {
            return resistance;
        }
        return state.getBlock().getExplosionResistance();
    }

    default public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        if (ConfigView.Server.INSTANCE.areBlocksFireproof()) {
            return false;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.isCamoFlammable(face);
        }
        return true;
    }

    default public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        FramedBlockEntity be;
        int flammability;
        if (ConfigView.Server.INSTANCE.areBlocksFireproof()) {
            return 0;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity && (flammability = (be = (FramedBlockEntity)blockEntity).getCamoFlammability(face)) > -1) {
            return flammability;
        }
        return 20;
    }

    default public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        FramedBlockEntity be;
        int spreadSpeed;
        if (ConfigView.Server.INSTANCE.areBlocksFireproof()) {
            return 0;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity && (spreadSpeed = (be = (FramedBlockEntity)blockEntity).getCamoFireSpreadSpeed(face)) > -1) {
            return spreadSpeed;
        }
        return 5;
    }

    default public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    default public boolean isIntangible(BlockState state, BlockGetter level, BlockPos pos, @Nullable CollisionContext ctx) {
        FramedBlockEntity be;
        if (!ConfigView.Server.INSTANCE.enableIntangibility() || !this.getBlockType().allowMakingIntangible()) {
            return false;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity instanceof FramedBlockEntity && (be = (FramedBlockEntity)blockEntity).isIntangible(ctx);
    }

    default public boolean isCamoEmissiveRendering(BlockState state, BlockGetter level, BlockPos pos) {
        ModelData modelData = level.getModelData(pos);
        return IFramedBlock.isCamoEmissiveRendering(modelData);
    }

    public static boolean isCamoEmissiveRendering(@Nullable ModelData modelData) {
        if (modelData == ModelData.EMPTY || modelData == null) {
            return false;
        }
        FramedBlockData fbData = (FramedBlockData)modelData.get(FramedBlockData.PROPERTY);
        if (fbData != null) {
            return fbData.getCamoContent().isEmissive();
        }
        return false;
    }

    default public boolean isSuffocating(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState stateAtPos;
        if (ConfigView.Server.INSTANCE.enableIntangibility() && this.getBlockType().allowMakingIntangible() && (state != (stateAtPos = level.getBlockState(pos)) || this.isIntangible(state, level, pos, null))) {
            return false;
        }
        return state.blocksMotion() && state.isCollisionShapeFullBlock(level, pos);
    }

    default public boolean useCamoOcclusionShapeForLightOcclusion(BlockState state) {
        if (this.getBlockType() != null && !this.getBlockType().canOccludeWithSolidCamo()) {
            return false;
        }
        return Utils.tryGetValue(state, FramedProperties.SOLID, false) != false && (Boolean)state.getValue((Property)FramedProperties.GLOWING) == false;
    }

    default public VoxelShape getCamoOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.getBlockType().canOccludeWithSolidCamo() && !((Boolean)state.getValue((Property)FramedProperties.SOLID)).booleanValue()) {
            return Shapes.empty();
        }
        return state.getShape(level, pos);
    }

    default public VoxelShape getCamoVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (this.getBlockType().canOccludeWithSolidCamo() && !((Boolean)state.getValue((Property)FramedProperties.SOLID)).booleanValue()) {
            return Shapes.empty();
        }
        return state.getCollisionShape(level, pos, ctx);
    }

    default public float getCamoShadeBrightness(BlockState state, BlockGetter level, BlockPos pos, float ownShade) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getCamoShadeBrightness(ownShade);
        }
        return ownShade;
    }

    default public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            ParticleHelper.spawnRunningParticles(be.getCamo(), level, pos, entity);
            return true;
        }
        return false;
    }

    default public boolean addLandingEffects(BlockState state, ServerLevel level, BlockPos pos, BlockState sameState, LivingEntity entity, int count) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            ParticleHelper.spawnLandingParticles(be.getCamo(), level, pos, entity, count);
            return true;
        }
        return false;
    }

    default public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        return CullingHelper.hidesNeighborFace(this, level, pos, state, adjState, side);
    }

    default public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        if (level.isClientSide()) {
            BlockEntity blockEntity;
            if (oldState.getBlock() == newState.getBlock()) {
                this.updateCulling(level, pos);
            }
            if ((blockEntity = level.getBlockEntity(pos)) instanceof FramedBlockEntity) {
                FramedBlockEntity be = (FramedBlockEntity)blockEntity;
                be.setBlockState(newState);
            }
        }
    }

    default public void updateCulling(LevelReader level, BlockPos pos) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && level instanceof Level) {
            Level realLevel = (Level)level;
            InternalAPI.INSTANCE.enqueueCullingUpdate(realLevel, pos);
        } else if (level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            be.updateCulling(true, false);
        }
    }

    default public boolean lockState(Level level, BlockPos pos, Player player, ItemStack stack) {
        if (stack.getItem() != Utils.FRAMED_KEY.value()) {
            return false;
        }
        if (!level.isClientSide()) {
            BlockState state = level.getBlockState(pos);
            boolean locked = (Boolean)state.getValue((Property)FramedProperties.STATE_LOCKED);
            player.displayClientMessage((Component)Component.translatable((String)LOCK_MESSAGE, (Object[])new Object[]{locked ? STATE_UNLOCKED : STATE_LOCKED}), true);
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)FramedProperties.STATE_LOCKED));
        }
        return true;
    }

    default public BlockState updateShapeLockable(BlockState state, LevelAccessor level, BlockPos pos, Supplier<BlockState> updateShape) {
        if (!((Boolean)state.getValue((Property)FramedProperties.STATE_LOCKED)).booleanValue()) {
            return updateShape.get();
        }
        if (this.getBlockType().supportsWaterLogging() && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return state;
    }

    default public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        return this.rotate(state, hit.getDirection(), rot);
    }

    default public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        return state.rotate(rot);
    }

    default public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        FramedBlockEntity be;
        MapColor color;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity && (color = (be = (FramedBlockEntity)blockEntity).getMapColor()) != null) {
            return color;
        }
        return defaultColor;
    }

    default public Integer getBeaconColorMultiplier(BlockState state, LevelReader level, BlockPos pos, BlockPos beaconPos) {
        if (!this.doesBlockOccludeBeaconBeam(state, level, pos)) {
            return null;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getCamoBeaconColorMultiplier(level, pos, beaconPos);
        }
        return null;
    }

    default public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return false;
    }

    default public TriState canSustainPlant(BlockState state, BlockGetter level, BlockPos pos, Direction side, BlockState plant) {
        BlockEntity blockEntity;
        if (state.isFaceSturdy(level, pos, side, SupportType.FULL) && (blockEntity = level.getBlockEntity(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.canCamoSustainPlant(side, plant);
        }
        return TriState.DEFAULT;
    }

    default public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluid) {
        BlockEntity blockEntity;
        if (!this.getBlockType().canOccludeWithSolidCamo()) {
            return false;
        }
        if (!((Boolean)state.getValue((Property)FramedProperties.SOLID)).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.shouldCamoDisplayFluidOverlay(level, pos, fluid);
        }
        return false;
    }

    default public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        FramedBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity && !(be = (FramedBlockEntity)blockEntity).canEntityDestroyCamo(entity)) {
            return false;
        }
        return super.canEntityDestroy(state, level, pos, entity);
    }

    default public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedBlockEntity(pos, state);
    }

    default public Optional<MutableComponent> printCamoBlock(BlueprintData blueprintData) {
        CamoContainer<?, ?> camoContent = blueprintData.camos().getCamo(0);
        if (camoContent.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((CamoContent)camoContent.getContent()).getCamoName().withStyle(ChatFormatting.WHITE));
    }

    public static boolean toggleYSlope(BlockState state, Level level, BlockPos pos, Player player) {
        if (player.getMainHandItem().getItem() == Utils.FRAMED_WRENCH.value()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)FramedProperties.Y_SLOPE) == false)));
            return true;
        }
        return false;
    }

    @Nullable
    public BlockState getItemModelSource();

    default public Class<? extends Block> getJadeTargetClass() {
        return ((Block)this).getClass();
    }

    default public boolean shouldRenderAsBlockInJadeTooltip() {
        return true;
    }

    public BlockState getJadeRenderState(BlockState var1);

    default public float getJadeRenderScale(BlockState state) {
        return 1.0f;
    }

    default public boolean shouldApplyGuiTransformFromModel() {
        return true;
    }
}

