/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.render.FramedBlockRenderProperties;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.type.IBlockType;

public abstract class AbstractFramedBlock
extends Block
implements IFramedBlock,
SimpleWaterloggedBlock {
    private static final VoxelShape BEACON_BEAM_SHAPE = AbstractFramedBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private final IBlockType blockType;
    private final ShapeProvider shapes;
    private final Reference2BooleanMap<BlockState> beaconBeamOcclusion;

    public AbstractFramedBlock(IBlockType blockType, BlockBehaviour.Properties props) {
        super(props);
        this.blockType = blockType;
        this.shapes = blockType.generateShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
        this.beaconBeamOcclusion = AbstractFramedBlock.computeBeaconBeamOcclusion(this.shapes);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.PROPAGATES_SKYLIGHT, (Comparable)Boolean.valueOf(false)));
        if (blockType.canOccludeWithSolidCamo()) {
            this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(false)));
        }
        if (blockType.supportsWaterLogging()) {
            this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleUse(state, level, pos, player, hand, hit);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        this.updateCulling((LevelReader)level, pos);
        if (this.isWaterLoggable() && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, pos, facingPos);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.updateCulling((LevelReader)level, pos);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (this.isIntangible(state, level, pos, ctx)) {
            return Shapes.empty();
        }
        return this.shapes.get(state);
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return this.useCamoOcclusionShapeForLightOcclusion(state);
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoOcclusionShape(state, level, pos);
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.getCamoVisualShape(state, level, pos, ctx);
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoShadeBrightness(state, level, pos, super.getShadeBrightness(state, level, pos));
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)FramedProperties.PROPAGATES_SKYLIGHT);
    }

    protected FluidState getFluidState(BlockState state) {
        if (this.isWaterLoggable() && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return Fluids.EMPTY.defaultFluidState();
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return this.isWaterLoggable() && super.canPlaceLiquid(player, level, pos, state, fluid);
    }

    public boolean placeLiquid(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        return this.isWaterLoggable() && super.placeLiquid(pLevel, pPos, pState, pFluidState);
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        if (!this.isWaterLoggable()) {
            return ItemStack.EMPTY;
        }
        return super.pickupBlock(player, level, pos, state);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return this.getCamoDrops(super.getDrops(state, builder), builder);
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        Preconditions.checkNotNull(this.beaconBeamOcclusion, (String)"Block '%s' handles shapes itself but doesn't override AbstractFramedBlock#doesBlockMaskBeaconBeam()", (Object)this);
        return this.beaconBeamOcclusion.getBoolean((Object)state);
    }

    @Override
    public IBlockType getBlockType() {
        return this.blockType;
    }

    protected final boolean isWaterLoggable() {
        return this.blockType.supportsWaterLogging();
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(FramedBlockRenderProperties.INSTANCE);
    }

    private static Reference2BooleanMap<BlockState> computeBeaconBeamOcclusion(ShapeProvider shapes) {
        if (shapes.isEmpty()) {
            return null;
        }
        Reference2BooleanOpenHashMap beamColorMasking = new Reference2BooleanOpenHashMap();
        shapes.forEach((arg_0, arg_1) -> AbstractFramedBlock.lambda$computeBeaconBeamOcclusion$0((Reference2BooleanMap)beamColorMasking, arg_0, arg_1));
        return beamColorMasking;
    }

    private static /* synthetic */ void lambda$computeBeaconBeamOcclusion$0(Reference2BooleanMap beamColorMasking, BlockState state, VoxelShape shape) {
        VoxelShape intersection = ShapeUtils.andUnoptimized(shape, BEACON_BEAM_SHAPE);
        beamColorMasking.put((Object)state, intersection.min(Direction.Axis.X) <= BEACON_BEAM_SHAPE.min(Direction.Axis.X) && intersection.min(Direction.Axis.Z) <= BEACON_BEAM_SHAPE.min(Direction.Axis.Z) && intersection.max(Direction.Axis.X) >= BEACON_BEAM_SHAPE.max(Direction.Axis.X) && intersection.max(Direction.Axis.Z) >= BEACON_BEAM_SHAPE.max(Direction.Axis.Z));
    }
}

