/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.waypoint;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.JourneymapClient;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.nbt.waypoint.WaypointDAO;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointStore;
import journeymap.common.waypoint.predefined.AllWaypointsGroup;
import journeymap.common.waypoint.predefined.LockedGroup;

@ParametersAreNonnullByDefault
public class WaypointGroupStore {
    private static WaypointGroupStore INSTANCE;
    public static final WaypointGroup DEFAULT;
    public static final WaypointGroup DEATH;
    public static final WaypointGroup TEMP;
    public static final WaypointGroup ALL;
    private final Map<String, WaypointGroup> groupMap = new LinkedHashMap<String, WaypointGroup>();
    public WaypointDAO dao;

    public static WaypointGroupStore getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WaypointGroupStore();
        }
        return INSTANCE;
    }

    public WaypointGroup get(String guid) {
        return this.groupMap.get(guid);
    }

    public List<Waypoint> getWaypoints(WaypointGroup group) {
        ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>();
        WaypointStore.getInstance().getAll().forEach(wp -> {
            if (wp.getGroupId().equals(group.getGuid())) {
                waypoints.add((Waypoint)wp);
            }
        });
        return waypoints;
    }

    public void put(WaypointGroup waypointGroup) {
        this.groupMap.put(waypointGroup.getGuid(), waypointGroup);
        this.dao.addGroup(waypointGroup);
        this.save();
    }

    public void remove(WaypointGroup waypointGroup) {
        List<Waypoint> waypointsInGroup = this.getWaypoints(waypointGroup);
        this.groupMap.remove(waypointGroup.getGuid());
        this.dao.deleteGroup(waypointGroup);
        waypointsInGroup.forEach(wp -> WaypointStore.getInstance().remove((ClientWaypointImpl)wp, false));
        this.save();
    }

    public void reset(WaypointDAO dao) {
        this.groupMap.clear();
        if (JourneymapClient.getInstance().getWaypointProperties().managerEnabled.get().booleanValue()) {
            this.dao = dao;
            this.load();
        }
    }

    public boolean transferWaypoint(WaypointGroup to, String waypointId) {
        ClientWaypointImpl waypoint = WaypointStore.getInstance().get(waypointId);
        if (this.canTransferWaypoint(to, waypoint)) {
            waypoint.setGroupId(to.getGuid());
            WaypointStore.getInstance().save(waypoint, false);
            return true;
        }
        return false;
    }

    public boolean canTransferWaypoint(WaypointGroup to, Waypoint waypoint) {
        WaypointGroup from = this.get(waypoint.getGroupId());
        return from != null && !this.isLockedGroup(to) && !this.isLockedGroup(from) && !ALL.getGuid().equals(to.getGuid()) && !from.getGuid().equals(to.getGuid());
    }

    private boolean isLockedGroup(WaypointGroup group) {
        return DEATH.getGuid().equals(group.getGuid()) || TEMP.getGuid().equals(group.getGuid()) || group.isLocked();
    }

    private void load() {
        this.groupMap.putAll(this.dao.getGroups());
        if (this.groupMap.isEmpty()) {
            this.put(DEFAULT);
            this.put(DEATH);
            this.put(TEMP);
            this.dao.save(false);
        }
    }

    public void save() {
        WaypointStore.getInstance().bulkSave();
        this.dao.save(false);
    }

    public List<WaypointGroup> getAll() {
        return this.groupMap.values().stream().toList();
    }

    public List<String> getWaypointsIds(WaypointGroupImpl waypointGroup) {
        return this.getWaypoints(waypointGroup).stream().map(Waypoint::getGuid).toList();
    }

    static {
        DEFAULT = new WaypointGroupImpl("journeymap", "default", "journeymap_default");
        DEATH = new LockedGroup("journeymap", "death", "journeymap_death");
        TEMP = new LockedGroup("journeymap", "temp", "journeymap_temp");
        ALL = new AllWaypointsGroup("journeymap", "all", "journeymap_all");
    }
}

