/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import java.util.List;
import journeymap.api.services.Services;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import journeymap.common.config.AdminAccessConfig;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.nbt.WorldIdData;
import journeymap.common.properties.DimensionProperties;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.PermissionProperties;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.properties.ServerOption;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PermissionsManager {
    private static PermissionsManager INSTANCE;

    public static PermissionsManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PermissionsManager();
        }
        return INSTANCE;
    }

    public void sendPermissions(ServerPlayer playerEntity) {
        GlobalProperties permissions = this.getPlayerConfig(playerEntity);
        if (permissions != null) {
            Journeymap.getInstance().getDispatcher().sendClientPermissions(playerEntity, permissions.toJsonString(false), this.canServerAdmin(playerEntity));
        }
    }

    private GlobalProperties getPlayerConfig(ServerPlayer player) {
        if (Services.COMMON_SERVICE.isDedicatedServer() || Minecraft.getInstance().getSingleplayerServer() != null && Minecraft.getInstance().getSingleplayerServer().isPublished()) {
            boolean useWorldId = PropertiesManager.getInstance().getGlobalProperties().useWorldId.get();
            String worldId = useWorldId ? WorldIdData.getWorldId() : null;
            Journeymap.getInstance().getDispatcher().sendWorldIdPacket(player, worldId);
        }
        return this.buildPermissions(player);
    }

    public boolean canServerAdmin(ServerPlayer player) {
        if (player != null) {
            List<String> admins = AdminAccessConfig.getInstance().getAdmins();
            for (String admin : admins) {
                if (!player.getUUID().toString().equals(admin) && !player.getName().getString().equalsIgnoreCase(admin) && !CommonConstants.debugOverride((Entity)player)) continue;
                return true;
            }
            if (Services.COMMON_SERVICE.isOp((Player)player)) {
                return AdminAccessConfig.getInstance().getOpAccess() || CommonConstants.debugOverride((Entity)player);
            }
        }
        return false;
    }

    private boolean canTeleport(ServerPlayer player) {
        ResourceKey<Level> playerDim = DimensionHelper.getDimension((Entity)player);
        if (PropertiesManager.getInstance().getDimProperties(playerDim).enabled.get().booleanValue()) {
            return PropertiesManager.getInstance().getDimProperties(playerDim).teleportEnabled.get();
        }
        if (PropertiesManager.getInstance().getGlobalProperties().teleportEnabled.get().booleanValue()) {
            return true;
        }
        return Services.COMMON_SERVICE.isOp((Player)player);
    }

    private GlobalProperties buildPermissions(ServerPlayer player) {
        PermissionProperties prop = PropertiesManager.getInstance().getDimProperties((ResourceKey<Level>)player.getCommandSenderWorld().dimension());
        GlobalProperties globalProp = PropertiesManager.getInstance().getGlobalProperties();
        boolean isOp = Services.COMMON_SERVICE.isOp((Player)player);
        if (!((DimensionProperties)prop).enabled.get().booleanValue()) {
            prop = globalProp;
        }
        GlobalProperties to = (GlobalProperties)new GlobalProperties().loadForClient(prop.toJsonString(true), true);
        to.journeymapEnabled.set(globalProp.journeymapEnabled.get() != false || isOp || CommonConstants.debugOverride((Entity)player));
        to.worldPlayerRadar.set(((ServerOption)((Object)globalProp.worldPlayerRadar.get())).enabled(isOp));
        to.allowDeathPoints.set(globalProp.allowDeathPoints.get());
        to.allowWaypoints.set(globalProp.allowWaypoints.get());
        to.showInGameBeacons.set(globalProp.showInGameBeacons.get());
        to.allowMultiplayerSettings.set((ServerOption)((Object)globalProp.allowMultiplayerSettings.get()));
        to.viewOnlyServerProperties.set(globalProp.viewOnlyServerProperties.get());
        to.teleportEnabled.set(this.canTeleport(player));
        to.radarEnabled.set(((ServerOption)((Object)prop.radarEnabled.get())).enabled(isOp));
        to.surfaceMapping.set(((ServerOption)((Object)prop.surfaceMapping.get())).enabled(isOp));
        to.topoMapping.set(((ServerOption)((Object)prop.topoMapping.get())).enabled(isOp));
        to.caveMapping.set(((ServerOption)((Object)prop.caveMapping.get())).enabled(isOp));
        to.renderRange.set(prop.renderRange.get());
        return to;
    }
}

