/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import com.google.common.base.MoreObjects;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import journeymap.common.Journeymap;
import journeymap.common.network.model.Location;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class TeleportPacket
implements Location {
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)"teleport_req");
    private double x;
    private double y;
    private double z;
    private String dim;

    public TeleportPacket() {
    }

    public TeleportPacket(double x, double y, double z, String dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
    }

    public static TeleportPacket decode(FriendlyByteBuf buf) {
        TeleportPacket packet = new TeleportPacket();
        try {
            if (buf.readableBytes() > 1) {
                packet.x = buf.readDouble();
                packet.y = buf.readDouble();
                packet.z = buf.readDouble();
                packet.dim = buf.readUtf(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for teleport packet: %s", t));
        }
        return packet;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public String getDim() {
        return this.dim;
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            buf.writeUtf(this.dim);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for teleport packet:" + String.valueOf(t));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.x).add("y", this.y).add("z", this.z).add("dim", (Object)this.dim).toString();
    }

    public static void handle(PacketContext<TeleportPacket> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            Journeymap.getInstance().getPacketHandler().handleTeleportPacket(ctx.sender(), (Location)ctx.message());
        }
    }
}

