/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ServerAdminRequestPropPacket {
    private Integer type;
    private String payload;
    private String dimension;
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)"admin_req");

    public ServerAdminRequestPropPacket() {
    }

    public ServerAdminRequestPropPacket(Integer type, String payload, String dimension) {
        this.payload = payload;
        this.type = type;
        this.dimension = dimension;
    }

    public ServerAdminRequestPropPacket(Integer type, String dimension) {
        this(type, "", dimension);
    }

    public int getType() {
        return this.type;
    }

    public String getPayload() {
        return this.payload;
    }

    public static ServerAdminRequestPropPacket decode(FriendlyByteBuf buf) {
        ServerAdminRequestPropPacket packet = new ServerAdminRequestPropPacket();
        try {
            if (buf.readableBytes() > 1) {
                buf.readByte();
                packet.type = buf.readInt();
                packet.dimension = buf.readUtf(Short.MAX_VALUE);
                packet.payload = buf.readUtf(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for server admin request: %s", t));
        }
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            if (this.payload != null && this.type != null && this.dimension != null) {
                buf.writeByte(42);
                buf.writeInt(this.type.intValue());
                buf.writeUtf(this.dimension);
                buf.writeUtf(this.payload);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for server admin request:" + String.valueOf(t));
        }
    }

    public static void handle(PacketContext<ServerAdminRequestPropPacket> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            Journeymap.getInstance().getPacketHandler().onAdminScreenOpen(ctx.sender(), ((ServerAdminRequestPropPacket)ctx.message()).getType(), ((ServerAdminRequestPropPacket)ctx.message()).dimension);
        } else {
            JourneymapClient.getInstance().getPacketHandler().onServerAdminDataResponse(((ServerAdminRequestPropPacket)ctx.message()).getType(), ((ServerAdminRequestPropPacket)ctx.message()).getPayload(), ((ServerAdminRequestPropPacket)ctx.message()).dimension);
        }
    }
}

