/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.handler;

import journeymap.api.services.Services;
import journeymap.client.Constants;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.nbt.PlayerData;
import journeymap.common.nbt.WorldIdData;
import journeymap.common.network.model.Location;
import journeymap.common.network.model.ServerPropertyType;
import journeymap.common.properties.DimensionProperties;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.MultiplayerProperties;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.properties.ServerOption;
import journeymap.common.util.JourneyMapTeleport;
import journeymap.common.util.PermissionsManager;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class PacketHandler {
    public void handleTeleportPacket(ServerPlayer player, Location location) {
        JourneyMapTeleport.instance().attemptTeleport((Entity)player, location);
    }

    public void onClientPermsRequest(ServerPlayer sender) {
        PermissionsManager.getInstance().sendPermissions(sender);
    }

    public void onAdminScreenOpen(ServerPlayer sender, int type, String dimension) {
        PropertiesManager pm = PropertiesManager.getInstance();
        if (PermissionsManager.getInstance().canServerAdmin(sender) || Services.COMMON_SERVICE.isClient() || pm.getGlobalProperties().viewOnlyServerProperties.get().booleanValue()) {
            Journeymap.getInstance().getDispatcher().sendServerAdminPacket(sender, type, switch (ServerPropertyType.getFromType(type)) {
                case ServerPropertyType.GLOBAL -> pm.getGlobalProperties().toJsonString(false);
                case ServerPropertyType.DEFAULT -> pm.getDefaultDimensionProperties().toJsonString(false);
                default -> pm.getDimProperties(DimensionHelper.getWorldKeyForName(dimension)).toJsonString(false);
            }, dimension);
        } else {
            sender.sendSystemMessage((Component)Constants.getStringTextComponent("You do not have permission to modify Journeymap's server options!"));
        }
    }

    public void onMultiplayerOptionsOpen(ServerPlayer sender) {
        GlobalProperties globalProperties = PropertiesManager.getInstance().getGlobalProperties();
        if (((ServerOption)((Object)globalProperties.allowMultiplayerSettings.get())).hasOption(Services.COMMON_SERVICE.isOp((Player)sender))) {
            PlayerData.Player player = PlayerData.getPlayerData().getPlayer(sender);
            MultiplayerProperties properties = new MultiplayerProperties();
            properties.visible.set(player.isVisible());
            properties.hideSelfUnderground.set(player.isHiddenUnderground());
            Journeymap.getInstance().getDispatcher().sendMultiplayerOptionsPacket(sender, properties.toJsonString(false));
        }
    }

    public void onMultiplayerOptionsSave(ServerPlayer sender, String payload) {
        GlobalProperties globalProperties = PropertiesManager.getInstance().getGlobalProperties();
        if (((ServerOption)((Object)globalProperties.allowMultiplayerSettings.get())).hasOption(Services.COMMON_SERVICE.isOp((Player)sender))) {
            PlayerData.Player player = PlayerData.getPlayerData().getPlayer(sender);
            MultiplayerProperties properties = new MultiplayerProperties();
            properties.load(payload, false);
            player.setHiddenUnderground(properties.hideSelfUnderground.get());
            player.setVisible(properties.visible.get());
        }
    }

    public void onServerAdminSave(ServerPlayer sender, Integer type, String payload, String dimension) {
        if (PermissionsManager.getInstance().canServerAdmin(sender) || Services.COMMON_SERVICE.isClient()) {
            switch (ServerPropertyType.getFromType(type)) {
                case GLOBAL: {
                    ((PropertiesBase)PropertiesManager.getInstance().getGlobalProperties().load(payload, false)).save();
                    PacketHandler.updatePlayers("global");
                    break;
                }
                case DEFAULT: {
                    ((PropertiesBase)PropertiesManager.getInstance().getDefaultDimensionProperties().load(payload, false)).save();
                    break;
                }
                default: {
                    DimensionProperties prop = (DimensionProperties)PropertiesManager.getInstance().getDimProperties(DimensionHelper.getWorldKeyForName(dimension)).load(payload, true);
                    prop.save();
                    if (!prop.enabled.get().booleanValue()) break;
                    PacketHandler.updatePlayers(dimension);
                }
            }
            PropertiesManager.getInstance().reloadConfigs();
        } else {
            sender.sendSystemMessage((Component)Constants.getStringTextComponent("You do not have permission to modify Journeymap's server options!"));
        }
    }

    private static void updatePlayers(String dim) {
        for (ServerPlayer player : Services.COMMON_SERVICE.getServer().getPlayerList().getPlayers()) {
            if (!dim.equals(DimensionHelper.getDimKeyName((Entity)player)) && !"global".equals(dim)) continue;
            PermissionsManager.getInstance().sendPermissions(player);
        }
    }

    public void onWorldIdRequest(ServerPlayer sender) {
        if (PropertiesManager.getInstance().getGlobalProperties().useWorldId.get().booleanValue()) {
            String worldId = WorldIdData.getWorldId();
            Journeymap.getInstance().getDispatcher().sendWorldIdPacket(sender, worldId);
        }
    }
}

