/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import java.io.File;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import journeymap.client.JourneymapClient;
import journeymap.client.io.FileHandler;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageSet;
import journeymap.client.task.multi.MapRegionTask;
import journeymap.common.nbt.RegionData;
import journeymap.common.nbt.cache.CacheStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;

public class RegionDataStorageHandler {
    private final Map<Key, RegionData> SYNC_DATA_MAP = new LinkedHashMap<Key, RegionData>();
    private final Map<MapType, CacheStorage> STORAGE_MAP = new LinkedHashMap<MapType, CacheStorage>();
    private RegionData lastHandler;
    private static RegionDataStorageHandler INSTANCE;

    public static RegionDataStorageHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RegionDataStorageHandler();
        }
        return INSTANCE;
    }

    private File getDir(RegionCoord rCoord) {
        File dimDir = rCoord.dimDir.toFile();
        if (!dimDir.exists()) {
            dimDir.mkdirs();
        }
        return dimDir;
    }

    @Nullable
    public Path getFile(RegionCoord regionCoord, MapType mapType) {
        File cacheDirectory;
        File directory = this.getDir(regionCoord);
        if (mapType.isUnderground()) {
            directory = new File(directory, mapType.vSlice.toString());
        }
        if (mapType.isTopo()) {
            directory = new File(directory, mapType.name());
        }
        if (!(cacheDirectory = new File(directory, "cache")).exists()) {
            cacheDirectory.mkdirs();
        }
        return cacheDirectory.toPath();
    }

    public RegionData getRegionDataAsyncNoCache(BlockPos blockPos, MapType mapType) {
        RegionCoord regionCoord = RegionCoord.fromChunkPos(FileHandler.getJMWorldDir(Minecraft.getInstance()), mapType, blockPos.getX() >> 4, blockPos.getZ() >> 4);
        return this.getRegionDataAsyncNoCache(regionCoord, mapType);
    }

    public RegionData getRegionDataAsyncNoCache(RegionCoord regionCoord, MapType mapType) {
        if (MapRegionTask.active || !JourneymapClient.getInstance().getCoreProperties().dataCachingEnabled.get().booleanValue()) {
            return null;
        }
        Key key = new Key(regionCoord, mapType);
        this.lastHandler = this.SYNC_DATA_MAP.containsKey(key) ? this.SYNC_DATA_MAP.get(key) : this.getRegionData(key);
        return this.lastHandler;
    }

    public RegionData getRegionData(Key key) {
        RegionData data = this.SYNC_DATA_MAP.get(key);
        if (data == null) {
            data = new RegionData(key, this.getCacheStorageSync(key.rCoord, key.mapType));
            this.SYNC_DATA_MAP.put(key, data);
        }
        return data;
    }

    private CacheStorage getCacheStorageSync(RegionCoord regionCoord, MapType mapType) {
        CacheStorage storage = this.STORAGE_MAP.get(mapType);
        if (storage == null) {
            storage = new CacheStorage(this.getFile(regionCoord, mapType), false);
            this.STORAGE_MAP.put(mapType, storage);
        }
        return storage;
    }

    public void flushDataCache() {
        this.STORAGE_MAP.values().forEach(CacheStorage::flushWorker);
        this.STORAGE_MAP.clear();
        this.SYNC_DATA_MAP.clear();
    }

    public void deleteCache() {
        this.flushDataCache();
    }

    public void removeRegion(RegionCoord rCoord, MapType mapType) {
        this.SYNC_DATA_MAP.remove(new Key(rCoord, mapType));
    }

    public static class Key {
        final RegionCoord rCoord;
        final MapType mapType;

        public Key(RegionCoord rCoord, MapType mapType) {
            this.rCoord = rCoord;
            this.mapType = mapType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.mapType.dimension.equals(key.mapType.dimension)) {
                return false;
            }
            if (this.mapType.isUnderground() != key.mapType.isUnderground()) {
                return false;
            }
            if (this.mapType.isUnderground() && !this.mapType.vSlice.equals(key.mapType.vSlice)) {
                return false;
            }
            if (this.mapType.isTopo() != key.mapType.isTopo()) {
                return false;
            }
            if (this.mapType.isSurfaceType() != key.mapType.isSurfaceType()) {
                return false;
            }
            if (this.rCoord.regionX != key.rCoord.regionX) {
                return false;
            }
            if (this.rCoord.worldDir != key.rCoord.worldDir) {
                return false;
            }
            return this.rCoord.regionZ == key.rCoord.regionZ;
        }

        public int hashCode() {
            int result = 31 + this.rCoord.regionX;
            result = 31 * result + this.rCoord.regionZ;
            result = 31 * result + this.mapType.dimension.hashCode();
            return result;
        }

        public String toString() {
            return new StringJoiner(", ", RegionImageSet.Key.class.getSimpleName() + "[", "]").add("isUnderground=" + this.mapType.isUnderground()).add("isSurfaceType=" + this.mapType.isSurfaceType()).add("isTopo=" + this.mapType.isTopo()).add("rCoord=" + String.valueOf(this.rCoord)).add("regionX=" + this.rCoord.regionX).add("regionZ=" + this.rCoord.regionZ).add("dimension=" + String.valueOf(this.mapType.dimension)).toString();
        }
    }
}

