/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import java.util.HashMap;
import java.util.Map;
import journeymap.api.services.Services;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class PlayerData
extends SavedData {
    private static final String DAT_FILE = "JMPlayerSettings";
    private CompoundTag data = new CompoundTag();
    Map<String, Player> playerMap = new HashMap<String, Player>();

    public PlayerData() {
        Services.COMMON_SERVICE.getServer().getLevel(Level.OVERWORLD).getDataStorage().set(DAT_FILE, (SavedData)this);
        this.setDirty();
    }

    public static PlayerData getPlayerData() {
        return PlayerData.get();
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        compound.put(DAT_FILE, (Tag)PlayerData.get().data);
        return compound;
    }

    private static PlayerData get() {
        ServerLevel level = Services.COMMON_SERVICE.getServer().getLevel(Level.OVERWORLD);
        return (PlayerData)level.getDataStorage().computeIfAbsent(PlayerData.dataFactory(), DAT_FILE);
    }

    private static PlayerData load(CompoundTag nbt, HolderLookup.Provider provider) {
        PlayerData playerData = new PlayerData();
        playerData.data = nbt.getCompound(DAT_FILE);
        return playerData;
    }

    public static SavedData.Factory<PlayerData> dataFactory() {
        return new SavedData.Factory(PlayerData::load, PlayerData::load, DataFixTypes.OPTIONS);
    }

    private static PlayerData load() {
        return new PlayerData();
    }

    public Player getPlayer(ServerPlayer serverPlayer) {
        String uuid = serverPlayer.getStringUUID();
        Player player = this.playerMap.get(uuid);
        if (player == null) {
            CompoundTag playerTag;
            if (this.data.contains(uuid)) {
                playerTag = this.data.getCompound(uuid);
            } else {
                playerTag = new CompoundTag();
                this.data.put(uuid, (Tag)playerTag);
            }
            player = new Player(this, uuid, playerTag);
            this.playerMap.put(uuid, player);
        }
        return player;
    }

    public static class Player {
        static final String HIDDEN_UNDERGROUND = "hidden_underground";
        static final String VISIBLE = "radar_visible";
        final String uuid;
        boolean hiddenUnderground;
        boolean visible;
        CompoundTag playerNbt;
        final PlayerData playerData;

        public Player(PlayerData playerData, String uuid, CompoundTag playerNbt) {
            this.playerData = playerData;
            this.uuid = uuid;
            this.playerNbt = playerNbt;
            this.readPlayerNbt();
        }

        public boolean isHiddenUnderground() {
            return this.hiddenUnderground;
        }

        public void setHiddenUnderground(boolean hiddenUnderground) {
            this.playerNbt.putBoolean(HIDDEN_UNDERGROUND, hiddenUnderground);
            this.hiddenUnderground = hiddenUnderground;
            this.playerData.setDirty();
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.playerNbt.putBoolean(VISIBLE, visible);
            this.visible = visible;
            this.playerData.setDirty();
        }

        private void readPlayerNbt() {
            if (this.playerNbt.contains(HIDDEN_UNDERGROUND)) {
                this.hiddenUnderground = this.playerNbt.getBoolean(HIDDEN_UNDERGROUND);
            } else {
                this.setHiddenUnderground(false);
            }
            if (this.playerNbt.contains(VISIBLE)) {
                this.visible = this.playerNbt.getBoolean(VISIBLE);
            } else {
                this.setVisible(true);
            }
        }
    }
}

