/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.events;

import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.UUID;
import journeymap.api.services.Services;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.nbt.PlayerData;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.properties.ServerOption;
import journeymap.common.util.PermissionsManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ServerEventHandler {
    private static int playerUpdateTicksCount = 0;

    public void onServerTickEvent(Level world) {
        if (((ServerOption)((Object)PropertiesManager.getInstance().getGlobalProperties().worldPlayerRadar.get())).enabled()) {
            int playerUpdateTicks = PropertiesManager.getInstance().getGlobalProperties().worldPlayerRadarUpdateTime.get();
            if (world != null && ++playerUpdateTicksCount >= playerUpdateTicks) {
                this.sendPlayersOnRadarToPlayers();
                playerUpdateTicksCount = 0;
            }
        }
    }

    public void onEntityJoinWorldEvent(Entity entity) {
        if (entity instanceof ServerPlayer) {
            this.sendConfigsToPlayer((ServerPlayer)entity);
        }
    }

    public void onPlayerLoggedInEvent(Player player) {
        if (player instanceof ServerPlayer) {
            Journeymap.getInstance().getDispatcher().sendHandshakePacket((ServerPlayer)player, Journeymap.JM_VERSION.toJson());
            this.sendConfigsToPlayer((ServerPlayer)player);
            PlayerData.getPlayerData().getPlayer((ServerPlayer)player);
        }
    }

    public void sendConfigsToPlayer(ServerPlayer player) {
        PermissionsManager.getInstance().sendPermissions(player);
    }

    private void sendPlayersOnRadarToPlayers() {
        GlobalProperties prop = PropertiesManager.getInstance().getGlobalProperties();
        ServerOption option = (ServerOption)((Object)prop.worldPlayerRadar.get());
        for (ServerPlayer player : Services.COMMON_SERVICE.getServer().getPlayerList().getPlayers()) {
            boolean playerRadarEnabled = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getDimension((Entity)player)).playerRadarEnabled.get();
            boolean receiverOp = Services.COMMON_SERVICE.isOp((Player)player);
            if ((!option.enabled() || !playerRadarEnabled) && (!option.canOps() || !receiverOp)) continue;
            try {
                this.sendPlayerTrackingData(player, receiverOp);
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
    }

    private void sendPlayerTrackingData(ServerPlayer entityPlayerMP, boolean receiverOp) {
        List serverPlayers = entityPlayerMP.server.getPlayerList().getPlayers();
        if (serverPlayers != null && serverPlayers.size() > 1) {
            GlobalProperties properties = PropertiesManager.getInstance().getGlobalProperties();
            for (ServerPlayer radarPlayer : serverPlayers) {
                boolean sameDimension = entityPlayerMP.getCommandSenderWorld().dimension().equals(radarPlayer.getCommandSenderWorld().dimension());
                boolean sneaking = radarPlayer.isShiftKeyDown();
                boolean invisible = radarPlayer.isInvisibleTo((Player)entityPlayerMP);
                boolean hideOp = properties.hideOps.get();
                boolean hideSpectators = properties.hideSpectators.get() != false && radarPlayer.isSpectator();
                boolean seeUnderground = this.seeUnderground(radarPlayer, receiverOp);
                boolean visible = sameDimension && (receiverOp && seeUnderground || !hideOp && !sneaking && !hideSpectators && !invisible && seeUnderground);
                boolean bl = visible = visible && this.isSelfHidden(radarPlayer, properties, receiverOp);
                if (visible) {
                    visible = entityPlayerMP.serverLevel().players().contains(radarPlayer);
                }
                UUID playerId = radarPlayer.getUUID();
                if (entityPlayerMP.getUUID().equals(playerId) || !entityPlayerMP.connection.isAcceptingMessages()) continue;
                Journeymap.getInstance().getDispatcher().sendPlayerLocationPacket(entityPlayerMP, radarPlayer, visible);
            }
        }
    }

    private boolean isSelfHidden(ServerPlayer radarPlayer, GlobalProperties properties, boolean receiverOp) {
        if (((ServerOption)((Object)properties.allowMultiplayerSettings.get())).hasOption(receiverOp) || ServerOption.OPS.equals(properties.allowMultiplayerSettings.get())) {
            PlayerData.Player player = PlayerData.getPlayerData().getPlayer(radarPlayer);
            boolean hiddenUnderground = player.isHiddenUnderground() && this.isUnderground(radarPlayer) && !Level.NETHER.equals(radarPlayer.getCommandSenderWorld().dimension());
            return receiverOp || player.isVisible() && !hiddenUnderground;
        }
        return true;
    }

    private boolean seeUnderground(ServerPlayer player, boolean isOp) {
        ServerOption seeUnderground = (ServerOption)((Object)PropertiesManager.getInstance().getGlobalProperties().seeUndergroundPlayers.get());
        if (!Level.NETHER.equals(player.getCommandSenderWorld().dimension()) && !ServerOption.ALL.equals((Object)seeUnderground) && this.isUnderground(player)) {
            return seeUnderground.hasOption(isOp);
        }
        return true;
    }

    private boolean isUnderground(ServerPlayer player) {
        return !player.getCommandSenderWorld().canSeeSky(BlockPos.containing((Position)player.getEyePosition()));
    }

    public void unloadPlayer(Entity entity, ServerLevel world) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            for (ServerPlayer onlinePlayer : world.getServer().getPlayerList().getPlayers()) {
                if (onlinePlayer.getUUID().equals(player.getUUID())) continue;
                Journeymap.getInstance().getDispatcher().sendPlayerLocationPacket(player, onlinePlayer, false);
            }
        }
    }
}

