/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.TreeSet;
import journeymap.client.texture.TextureCache;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.codecs.MiscCodecs;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointIcon;
import journeymap.common.waypoint.WaypointImpl;
import journeymap.common.waypoint.WaypointOrigin;
import journeymap.common.waypoint.WaypointPos;
import journeymap.common.waypoint.WaypointSettings;
import net.minecraft.resources.ResourceLocation;

public class WaypointCodecs {
    static MapCodec<TreeSet<String>> DIMENSIONS_CODEC = MiscCodecs.treeSetCodec(Codec.STRING).optionalFieldOf("dimensions", new TreeSet()).flatXmap(set -> {
        TreeSet newSet = new TreeSet();
        set.forEach(dim -> newSet.add(WaypointCodecs.waypointMigration(dim)));
        return DataResult.success(newSet);
    }, DataResult::success);
    static MapCodec<WaypointPos> LEGACY_POS_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(a -> null), (App)Codec.INT.fieldOf("y").forGetter(a -> null), (App)Codec.INT.fieldOf("z").forGetter(a -> null)).apply((Applicative)instance, WaypointPos::new));
    static MapCodec<Integer> LEGACY_COLOR_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("r").forGetter(a -> null), (App)Codec.INT.fieldOf("g").forGetter(a -> null), (App)Codec.INT.fieldOf("b").forGetter(a -> null)).apply((Applicative)instance, (red, green, blue) -> 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF));
    static MapCodec<WaypointSettings> LEGACY_SETTINGS_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("enable").forGetter(a -> null), (App)Codec.BOOL.fieldOf("showDeviation").forGetter(a -> null), (App)Codec.BOOL.fieldOf("persistent").forGetter(a -> null)).apply((Applicative)instance, WaypointSettings::new));
    static MapCodec<WaypointIcon> LEGACY_ICON_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("icon").forGetter(a -> null), (App)Codec.INT.optionalFieldOf("iconColor", (Object)-1).forGetter(a -> null)).apply((Applicative)instance, (icon, color) -> {
        ResourceLocation location = switch (icon) {
            case "waypoint-death-icon-map.png", "waypoint-death.png" -> TextureCache.Deathpoint;
            case "waypoint-normal.png" -> TextureCache.Waypoint;
            default -> ResourceLocation.parse((String)icon);
        };
        WaypointIcon waypointIcon = new WaypointIcon(location);
        waypointIcon.setColor(color == -1 ? null : color);
        return waypointIcon;
    }));
    public static Codec<WaypointImpl> LEGACY_WAYPOINT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(WaypointImpl::getName), (App)LEGACY_POS_CODEC.forGetter(a -> null), (App)LEGACY_COLOR_CODEC.forGetter(a -> null), (App)LEGACY_SETTINGS_CODEC.forGetter(a -> null), (App)Codec.STRING.fieldOf("type").forGetter(WaypointImpl::getName), (App)Codec.STRING.fieldOf("origin").forGetter(WaypointImpl::getOrigin), (App)DIMENSIONS_CODEC.forGetter(WaypointImpl::getDimensions), (App)LEGACY_ICON_CODEC.forGetter(a -> null)).apply((Applicative)instance, (name, pos, color, settings, type, origin, dims, icon) -> {
        String groupId = WaypointGroupStore.DEFAULT.getGuid();
        if ("Death".equalsIgnoreCase((String)type)) {
            groupId = WaypointGroupStore.DEATH.getGuid();
        } else if (WaypointOrigin.TEMP.getValue().equals(origin)) {
            groupId = WaypointGroupStore.TEMP.getGuid();
        }
        return new ClientWaypointImpl((String)name, (WaypointPos)pos, (Integer)color, (WaypointSettings)settings, (String)origin, (TreeSet<String>)dims, (WaypointIcon)icon, groupId);
    }));
    public static Codec<WaypointImpl> V1_WAYPOINT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(WaypointImpl::getName), (App)Codec.STRING.optionalFieldOf("version", (Object)"1").forGetter(WaypointImpl::getVersion), (App)Codec.STRING.fieldOf("modId").forGetter(WaypointImpl::getModId), (App)Codec.STRING.fieldOf("guid").forGetter(WaypointImpl::getGuid), (App)Codec.STRING.fieldOf("origin").forGetter(WaypointImpl::getOrigin), (App)Codec.STRING.fieldOf("groupId").forGetter(WaypointImpl::getGroupId), (App)WaypointPos.CODEC.fieldOf("pos").forGetter(WaypointImpl::getPos), (App)Codec.INT.fieldOf("color").forGetter(WaypointImpl::getColor), (App)WaypointIcon.CODEC.fieldOf("icon").forGetter(WaypointImpl::getIcon), (App)WaypointSettings.CODEC.fieldOf("settings").forGetter(WaypointImpl::getSettings), (App)DIMENSIONS_CODEC.forGetter(WaypointImpl::getDimensions), (App)Codec.STRING.optionalFieldOf("customData").forGetter(waypoint -> Optional.ofNullable(waypoint.getCustomData()))).apply((Applicative)instance, ClientWaypointImpl::new));
    public static final Codec<WaypointImpl> WAYPOINT_CODEC = Codec.either(LEGACY_WAYPOINT_CODEC, V1_WAYPOINT_CODEC).xmap(e -> (WaypointImpl)e.map(p -> p, p -> p), Either::right);

    private static String waypointMigration(String dimension) {
        return switch (dimension) {
            case "0", "overworld" -> "minecraft:overworld";
            case "1", "the_end" -> "minecraft:the_end";
            case "-1", "the_nether" -> "minecraft:the_nether";
            default -> dimension;
        };
    }
}

