/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common;

import journeymap.client.JourneymapClientNeoForge;
import journeymap.common.Journeymap;
import journeymap.common.config.NeoForgeConfig;
import journeymap.common.event.NeoForgeServerEvents;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;

@Mod(value="journeymap")
public class JourneymapNeoForge {
    private final Journeymap journeymap = new Journeymap();

    public JourneymapNeoForge(IEventBus eventBus) {
        if (FMLEnvironment.dist.isClient()) {
            new JourneymapClientNeoForge(eventBus);
        }
        eventBus.addListener(this::commonSetupEvent);
        NeoForge.EVENT_BUS.addListener(this::serverStartingEvent);
        eventBus.addListener(this::imc);
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)NeoForgeConfig.SERVER_SPEC);
        eventBus.addListener(this::serverConfig);
    }

    public void commonSetupEvent(FMLCommonSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new NeoForgeServerEvents());
    }

    private void imc(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"darkmodeeverywhere", (String)"dme-shaderblacklist", () -> "journeymap");
    }

    public void serverConfig(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            this.journeymap.setAdminConfig(new NeoForgeConfig());
        }
    }

    public void serverStartingEvent(ServerStartingEvent event) {
        this.journeymap.serverStarted(event.getServer());
    }
}

