/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.Constants;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class WaypointParser {
    public static String[] QUOTES = new String[]{"'", "\""};
    public static Pattern PATTERN = Pattern.compile("(\\w+\\s*:\\s*-?[\\w\\d\\s'\"]+,\\s*)+(\\w+\\s*:\\s*-?[\\w\\d\\s'\"]+)", 2);
    private static Pattern TEXT_BETWEEN_QUOTES = Pattern.compile("\".*?\"|'.*?'|`.*`");

    public static List<String> getWaypointStrings(String line) {
        ArrayList<CallSite> list = null;
        String[] candidates = StringUtils.substringsBetween((String)line, (String)"[", (String)"]");
        if (candidates != null) {
            for (String candidate : candidates) {
                if (!PATTERN.matcher(candidate).find() || WaypointParser.parse(candidate) == null) continue;
                if (list == null) {
                    list = new ArrayList<CallSite>(1);
                }
                list.add((CallSite)((Object)("[" + candidate + "]")));
            }
        }
        return list;
    }

    public static List<Waypoint> getWaypoints(String line) {
        ArrayList<Waypoint> list = null;
        String[] candidates = StringUtils.substringsBetween((String)line, (String)"[", (String)"]");
        if (candidates != null) {
            for (String candidate : candidates) {
                Waypoint waypoint;
                if (!PATTERN.matcher(candidate).find() || (waypoint = WaypointParser.parse(candidate)) == null) continue;
                if (list == null) {
                    list = new ArrayList<Waypoint>(1);
                }
                list.add(waypoint);
            }
        }
        return list;
    }

    public static Waypoint parse(String original) {
        String[] quotedVals = null;
        String raw = original.replaceAll("[\\[\\]]", "");
        for (String quoteChar : QUOTES) {
            if (!raw.contains(quoteChar) || (quotedVals = StringUtils.substringsBetween((String)raw, (String)quoteChar, (String)quoteChar)) == null) continue;
            for (int i = 0; i < quotedVals.length; ++i) {
                raw = raw.replaceAll(TEXT_BETWEEN_QUOTES.pattern(), "__TEMP_" + i);
            }
        }
        Integer x = null;
        Integer y = 63;
        Integer z = null;
        String dim = null;
        String name = null;
        boolean showDeviation = false;
        for (String part : raw.split(",")) {
            String[] prop;
            if (!part.contains(":") || (prop = part.split(":")).length != 2) continue;
            String key = prop[0].trim().toLowerCase();
            String val = prop[1].trim();
            try {
                if ("x".equals(key)) {
                    x = Integer.parseInt(val);
                } else if ("y".equals(key)) {
                    y = Integer.parseInt(val);
                } else if ("z".equals(key)) {
                    z = Integer.parseInt(val);
                } else if ("dim".equals(key)) {
                    dim = val;
                } else if ("name".equals(key)) {
                    name = val;
                }
                if (!"showDeviation".equals(key)) continue;
                showDeviation = Boolean.parseBoolean(val);
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Bad format in waypoint text part: " + part + ": " + String.valueOf(e));
            }
        }
        if (x != null && z != null) {
            if (name != null && quotedVals != null) {
                for (int i = 0; i < quotedVals.length; ++i) {
                    String val = quotedVals[i];
                    name = name.replaceAll("__TEMP_" + i, val);
                }
            }
            if (name == null) {
                name = String.format("%s,%s", x, z);
            }
            Random r = new Random();
            if (dim == null) {
                dim = Minecraft.getInstance() == null ? "minecraft:overworld" : DimensionHelper.getDimKeyName((ResourceKey<Level>)Minecraft.getInstance().level.dimension());
            }
            return WaypointFactoryImpl.createWaypoint("journeymap", new BlockPos(x.intValue(), y.intValue(), z.intValue()), name, dim, showDeviation);
        }
        return null;
    }

    public static Component parseChatForWaypoints(Component component, String unformattedText) {
        List<String> matches = WaypointParser.getWaypointStrings(unformattedText);
        Component response = null;
        if (matches != null) {
            boolean changed = false;
            ComponentContents componentContents = component.getContents();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents contents = (TranslatableContents)componentContents;
                Object[] formatArgs = contents.getArgs();
                for (int i = 0; i < formatArgs.length && !matches.isEmpty(); ++i) {
                    Component result;
                    Object arg;
                    if (formatArgs[i] instanceof Component) {
                        arg = (Component)formatArgs[i];
                        result = WaypointParser.addWaypointMarkup(arg.getString(), matches);
                        if (result == null) continue;
                        formatArgs[i] = result;
                        changed = true;
                        continue;
                    }
                    if (!(formatArgs[i] instanceof String) || (result = WaypointParser.addWaypointMarkup((String)(arg = (String)formatArgs[i]), matches)) == null) continue;
                    formatArgs[i] = result;
                    changed = true;
                }
                if (changed) {
                    response = Component.translatable((String)contents.getKey(), (Object[])formatArgs);
                }
            } else if (component instanceof MutableComponent) {
                response = WaypointParser.addWaypointMarkup(component.getString(), matches);
                if (response != null) {
                    changed = true;
                }
            } else {
                Journeymap.getLogger().warn("No implementation for handling waypoints in ITextComponent " + String.valueOf(component.getClass()));
            }
            if (!changed) {
                Journeymap.getLogger().warn(String.format("Matched waypoint in chat but failed to update message for %s : %s\n%s", component.getClass(), component.getString(), Component.Serializer.toJson((Component)component, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())));
            }
            return response;
        }
        return component;
    }

    private static Component addWaypointMarkup(String text, List<String> matches) {
        ArrayList<MutableComponent> newParts = new ArrayList<MutableComponent>();
        int index = 0;
        boolean matched = false;
        Iterator<String> iterator = matches.iterator();
        while (iterator.hasNext()) {
            String match = iterator.next();
            if (!text.contains(match)) continue;
            int start = text.indexOf(match);
            if (start > index) {
                newParts.add(Constants.getStringTextComponent(text.substring(index, start)));
            }
            matched = true;
            MutableComponent mutableComponent = Constants.getStringTextComponent(match);
            mutableComponent.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/jm wpedit " + match)));
            MutableComponent hover = Constants.getStringTextComponent("JourneyMap: ");
            hover.withStyle(style -> style.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.YELLOW)));
            MutableComponent hover2 = Constants.getStringTextComponent("Click to create Waypoint.\nCtrl+Click to view on map.");
            hover2.withStyle(style -> style.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.AQUA)));
            hover.append((Component)hover2);
            mutableComponent.withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)hover)));
            mutableComponent.withStyle(style -> style.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.AQUA)));
            newParts.add(mutableComponent);
            index = start + match.length();
            iterator.remove();
        }
        if (!matched) {
            return null;
        }
        if (index < text.length() - 1) {
            newParts.add(Constants.getStringTextComponent(text.substring(index, text.length())));
        }
        if (!newParts.isEmpty()) {
            MutableComponent replacement = Constants.getStringTextComponent("");
            for (Component component : newParts) {
                replacement.append(component);
            }
            return replacement;
        }
        return null;
    }
}

