/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import journeymap.client.io.FileHandler;
import journeymap.common.codecs.WaypointCodecs;
import journeymap.common.codecs.WaypointGroupCodecs;
import journeymap.common.nbt.waypoint.WaypointDAO;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointImpl;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;

public class ClientWaypointDAO
extends WaypointDAO {
    protected static final String DAT_FILE = "WaypointData.dat";

    public ClientWaypointDAO() {
        this.data = this.load();
    }

    @Override
    public Map<String, WaypointGroupImpl> decodeGroups(CompoundTag data) {
        LinkedHashMap<String, WaypointGroupImpl> groups = new LinkedHashMap<String, WaypointGroupImpl>();
        if (data.contains("groups")) {
            CompoundTag groupsTags = data.getCompound("groups");
            for (String key : groupsTags.getAllKeys()) {
                Tag tag = groupsTags.get(key);
                DataResult result = WaypointGroupCodecs.V1_WAYPOINT_GROUP_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag);
                if (!result.result().isPresent()) continue;
                WaypointGroupImpl group = (WaypointGroupImpl)result.result().get();
                groups.put(group.getGuid(), group);
            }
        }
        return groups;
    }

    @Override
    public CompoundTag encodeGroups(Collection<WaypointGroupImpl> groups) {
        CompoundTag tag = new CompoundTag();
        tag.put("groups", (Tag)new CompoundTag());
        CompoundTag groupsTag = tag.getCompound("groups");
        for (WaypointGroupImpl group : groups) {
            DataResult result = WaypointGroupCodecs.V1_WAYPOINT_GROUP_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)group);
            if (!result.result().isPresent()) continue;
            groupsTag.put(group.getGuid(), (Tag)result.result().get());
        }
        return tag;
    }

    @Override
    public Map<String, WaypointImpl> decodeWaypoints(CompoundTag data) {
        LinkedHashMap<String, WaypointImpl> waypoints = new LinkedHashMap<String, WaypointImpl>();
        if (data.contains("waypoints")) {
            CompoundTag groupsTags = data.getCompound("waypoints");
            for (String key : groupsTags.getAllKeys()) {
                Tag tag = groupsTags.get(key);
                DataResult result = WaypointCodecs.V1_WAYPOINT_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag);
                if (!result.result().isPresent()) continue;
                WaypointImpl waypoint = (WaypointImpl)result.result().get();
                waypoints.put(waypoint.getGuid(), waypoint);
            }
        }
        return waypoints;
    }

    @Override
    public CompoundTag encodeWaypoints(Collection<WaypointImpl> waypoints) {
        CompoundTag tag = new CompoundTag();
        tag.put("waypoints", (Tag)new CompoundTag());
        CompoundTag wpTag = tag.getCompound("waypoints");
        for (WaypointImpl wp : waypoints) {
            DataResult result = WaypointCodecs.V1_WAYPOINT_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)wp);
            if (!result.result().isPresent()) continue;
            wpTag.put(wp.getGuid(), (Tag)result.result().get());
        }
        return tag;
    }

    private File getFile() {
        return new File(FileHandler.getWaypointDir(), DAT_FILE);
    }

    private void write(Path path) {
        try {
            NbtIo.write((CompoundTag)this.data, (Path)path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void save(boolean async) {
        if (async) {
            Util.ioPool().execute(() -> this.write(this.getFile().toPath()));
        } else {
            this.write(this.getFile().toPath());
        }
    }

    @Override
    public Map<String, WaypointGroupImpl> getGroups() {
        return this.decodeGroups(this.data);
    }

    @Override
    public Map<String, WaypointImpl> getWaypoints() {
        return this.decodeWaypoints(this.data);
    }

    private CompoundTag load() {
        try {
            if (this.getFile().exists()) {
                return NbtIo.read((Path)this.getFile().toPath());
            }
            return new CompoundTag();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

