/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint.legacy;

import journeymap.client.Constants;
import journeymap.client.ui.component.buttons.OnOffButton;
import journeymap.client.ui.waypoint.legacy.WaypointManagerItem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

class SortButton
extends OnOffButton {
    final WaypointManagerItem.Sort sort;
    final String labelInactive;

    public SortButton(String label, WaypointManagerItem.Sort sort, Button.OnPress onPress) {
        super(String.format("%s %s", label, "\u25b2"), String.format("%s %s", label, "\u25bc"), sort.ascending, onPress);
        this.labelInactive = label;
        this.sort = sort;
    }

    @Override
    public void toggle() {
        this.sort.ascending = !this.sort.ascending;
        this.setActive(true);
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float f) {
        super.renderWidget(graphics, mouseX, mouseY, f);
        super.drawUnderline(graphics);
    }

    public void setActive(boolean active) {
        if (active) {
            this.setToggled(this.sort.ascending);
        } else {
            this.setMessage((Component)Constants.getStringTextComponent(String.format("%s %s", this.labelInactive, " ")));
        }
    }
}

