/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint.legacy;

import java.util.List;
import journeymap.client.Constants;
import journeymap.client.data.WorldData;
import journeymap.client.ui.component.buttons.Button;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

class DimensionsButton
extends Button {
    static boolean needInit = true;
    static WorldData.DimensionProvider currentWorldProvider;
    final List<WorldData.DimensionProvider> dimensionProviders = WorldData.getDimensionProviders(WaypointStore.getInstance().getLoadedDimensions());
    static int index;

    public DimensionsButton(Button.OnPress onPress) {
        super(0, 0, "", onPress);
        if (needInit) {
            currentWorldProvider = null;
            needInit = false;
        }
        this.updateLabel();
        this.fitWidth(Minecraft.getInstance().font);
    }

    public void setDim(ResourceKey<Level> dim) {
        index = -1;
        WorldData.DimensionProvider provider = this.dimensionProviders.stream().filter(dimensionProvider -> dim.equals(dimensionProvider.getDimension())).findFirst().orElse(null);
        for (WorldData.DimensionProvider p : this.dimensionProviders) {
            ++index;
            this.getProvider();
            if (!p.equals(provider)) continue;
            return;
        }
    }

    @Override
    protected void updateLabel() {
        String dimName = currentWorldProvider != null ? currentWorldProvider.getName() : Constants.getString("jm.waypoint.dimension_all");
        this.setMessage((Component)Constants.getStringTextComponent(Constants.getString("jm.waypoint.dimension", dimName)));
    }

    @Override
    public int getFitWidth(Font fr) {
        int maxWidth = 0;
        for (WorldData.DimensionProvider dimensionProvider : this.dimensionProviders) {
            String name = Constants.getString("jm.waypoint.dimension", WorldData.getSafeDimensionName(dimensionProvider));
            maxWidth = Math.max(maxWidth, Minecraft.getInstance().font.width(name));
        }
        return maxWidth + 12;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean clicked = super.mouseClicked(mouseX, mouseY, button);
        if (clicked && button == 0) {
            ++index;
            this.getProvider();
        } else if (clicked && button == 1) {
            --index;
            this.getProvider();
        }
        if (clicked) {
            super.onPress();
        }
        return clicked;
    }

    @Override
    public void onPress() {
    }

    protected boolean isValidClickButton(int button) {
        return button == 0 || button == 1;
    }

    private void getProvider() {
        if (index >= this.dimensionProviders.size()) {
            index = -1;
        } else if (index < -1) {
            index = this.dimensionProviders.size() - 1;
        }
        currentWorldProvider = index >= this.dimensionProviders.size() || index < 0 ? null : this.dimensionProviders.get(index);
        this.updateLabel();
    }

    static {
        index = -1;
    }
}

