/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint.group;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.DropDownItem;
import journeymap.client.ui.component.SelectableParent;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.ThreeLineButton;
import journeymap.client.ui.component.popupscreenbutton.PopupMenu;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypoint.ManagerSlot;
import journeymap.client.ui.waypoint.group.EditGroupPopup;
import journeymap.common.waypoint.WaypointGroupStore;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class GroupSlot
extends ManagerSlot
implements SelectableParent {
    private final WaypointGroup group;
    private int width;
    private int height;
    boolean selected = false;
    private int x;
    private int y;
    boolean popupWasOpen = false;
    Button editButton;
    PopupMenu popupMenu;
    ManagerSlot.ToolTipMeta tooltips;

    public GroupSlot(WaypointGroup group, int width, int height) {
        this.group = group;
        this.width = width;
        this.height = height;
        this.editButton = new ThreeLineButton(2, 10, 10, this::optionsClicked);
        this.buildTooltips();
    }

    private void buildTooltips() {
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
        tooltip.add(FormattedCharSequence.forward((String)this.group.getName(), (Style)Style.EMPTY.applyFormat(ChatFormatting.AQUA)));
        if (this.group.getDescription() != null) {
            tooltip.add(FormattedCharSequence.forward((String)this.group.getDescription(), (Style)Style.EMPTY.applyFormat(ChatFormatting.AQUA)));
        }
        tooltip.add(FormattedCharSequence.forward((String)("Waypoints: " + this.group.getWaypointIds().stream().count()), (Style)Style.EMPTY.applyFormat(ChatFormatting.GREEN)));
        tooltip.add(FormattedCharSequence.forward((String)("Id: " + this.group.getGuid()), (Style)Style.EMPTY.applyFormat(ChatFormatting.BLUE)));
        this.tooltips = new ManagerSlot.ToolTipMeta(tooltip);
    }

    private void optionsClicked(net.minecraft.client.gui.components.Button button) {
        this.optionsPopup(button.getX(), button.getY());
    }

    private void editGroup(net.minecraft.client.gui.components.Button button) {
        new EditGroupPopup((Component)Component.translatable((String)"Edit Group"), this.group).display();
        WaypointGroupStore.getInstance().put(this.group);
    }

    private void deleteGroup(net.minecraft.client.gui.components.Button button) {
        System.out.println("delete group");
    }

    private void optionsPopup(int x, int y) {
        this.popupMenu = new PopupMenu(Minecraft.getInstance().screen);
        this.popupMenu.setClickLoc(x, y);
        this.popupMenu.display(List.of(new DropDownItem((SelectableParent)this, (Object)this.group.getGuid(), true, "Edit", this::editGroup), new DropDownItem((SelectableParent)this, (Object)this.group.getGuid(), true, "Delete", this::deleteGroup)));
    }

    @Override
    public int compareTo(@NotNull ManagerSlot o) {
        return 0;
    }

    @Override
    public Collection<SlotMetadata> getMetadata() {
        return null;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        return false;
    }

    public boolean keyPressed(int key, int value, int modifier) {
        return false;
    }

    @Override
    public List<? extends Slot> getChildSlots(int listWidth, int columnWidth) {
        return new ArrayList();
    }

    @Override
    public SlotMetadata getLastPressed() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        return this.tooltips;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public int getColumnWidth() {
        return 0;
    }

    @Override
    public boolean contains(SlotMetadata slotMetadata) {
        return false;
    }

    public void render(GuiGraphics graphics, int slotIndex, int y, int x, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        boolean drawHovered = isMouseOver;
        this.x = x;
        this.y = y;
        this.width = rowWidth;
        this.height = itemHeight;
        this.editButton.setX(x + 1);
        this.editButton.setY(y + 3);
        Font font = Minecraft.getInstance().font;
        Integer color = drawHovered ? backgroundHover : background;
        float alpha = drawHovered ? 1.0f : 0.4f;
        DrawUtil.drawRectangle(graphics, x, y, rowWidth - 4, itemHeight, color, alpha);
        if (this.selected) {
            DrawUtil.drawRectangle(graphics, x, y, rowWidth - 4, itemHeight, backgroundHover, 1.0f);
        }
        int ct = this.group.getWaypointIds().size();
        String name = this.group.getName();
        graphics.drawString(font, String.format("%s (%s)", name, ct), x + 15, y + 3, -1);
        if (this.selected) {
            this.editButton.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public void renderTransferStatus(GuiGraphics graphics, boolean transferable) {
        int color = transferable ? 65280 : 0xFF0000;
        this.outline(graphics, this.x, this.y, this.width - 4, this.height, color, 0.8f);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1) {
            this.popupWasOpen = true;
            this.optionsPopup((int)mouseX, (int)mouseY);
            return true;
        }
        this.selected = this.isMouseOver(mouseX, mouseY);
        if (this.selected) {
            this.popupWasOpen = this.editButton.mouseClicked(mouseX, mouseY, button);
        }
        return this.selected;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.popupWasOpen) {
            this.selected = this.isMouseOver(mouseX, mouseY);
        }
        this.popupWasOpen = false;
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public WaypointGroup getGroup() {
        return this.group;
    }

    @Override
    public void setSelected(DropDownItem button) {
        this.popupMenu.setSelected(button);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("group", (Object)this.group.getName()).toString();
    }
}

