/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint.group;

import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.waypoint.WaypointManager;
import journeymap.client.ui.waypoint.group.GroupSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;

public class GroupPanel<T extends GroupSlot>
extends ScrollListPane<T> {
    private int lastIndex = -1;
    final int offset = 7;
    final WaypointManager manager;

    public GroupPanel(Minecraft mc, WaypointManager manager, int x, int y, int width, int height, int slotHeight) {
        super(mc, x, y, width, height, slotHeight);
        this.manager = manager;
    }

    @Override
    public void updateSize(int width, int height, int x, int y) {
        super.setRectangle(width, height, x - 3, y);
        this.scrollbarX = this.width + x - 7;
        this.listWidth = this.width - 7;
    }

    @Override
    public void setListWidth(int width) {
        this.scrollbarX = (this.width + width) / 2 - 7;
        this.listWidth = width - 7;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        try {
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.getChildAt(mouseX, mouseY);
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public void renderListItems(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        try {
            super.renderListItems(graphics, mouseX, mouseY, partialTicks);
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    public void renderItem(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
        try {
            super.renderItem(guiGraphics, mouseX, mouseY, partialTick, index, left, top, width, height);
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    public void renderSelection(GuiGraphics guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
        try {
            super.renderSelection(guiGraphics, top, width, height, outerColor, innerColor);
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int i, int j, float f) {
    }

    @Override
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        Slot focused = null;
        if (this.getItemCount() == 0) {
            return null;
        }
        if (event instanceof FocusNavigationEvent.ArrowNavigation) {
            ComponentPath path;
            FocusNavigationEvent.ArrowNavigation nav = (FocusNavigationEvent.ArrowNavigation)event;
            ScreenDirection direction = nav.direction();
            switch (direction) {
                case UP: 
                case DOWN: {
                    focused = (Slot)this.nextEntry(event.getVerticalDirectionForInitialFocus());
                    if (focused == null) break;
                    this.manager.updateSelectedGroup(focused);
                    break;
                }
                case RIGHT: {
                    this.lastIndex = this.children().indexOf(this.getFocused());
                    break;
                }
                case LEFT: {
                    focused = this.lastIndex > -1 ? this.getSlot(this.lastIndex) : this.getSlot(0);
                    this.manager.updateSelectedGroup(focused);
                }
            }
            do {
                if (focused != null) continue;
                return null;
            } while ((path = focused.children().isEmpty() ? ComponentPath.leaf((GuiEventListener)focused) : focused.focusPathAtIndex((FocusNavigationEvent)nav, this.lastIndex)) == null);
            return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)path);
        }
        return super.nextFocusPath(event);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public void unselect() {
        this.getRootSlots().forEach(slot -> slot.setSelected(false));
    }

    protected boolean isValidMouseClick(int button) {
        return button == 0 || button == 1;
    }
}

