/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import java.util.Collection;
import java.util.List;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypoint.ManagerSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;

public class WaypointSlot
extends ManagerSlot {
    private final Waypoint waypoint;
    private boolean dragging = false;
    private double dragX;
    private double dragY;
    int y;
    int x;
    int listWidth;
    int itemHeight;

    public WaypointSlot(Waypoint waypoint) {
        this.waypoint = waypoint;
    }

    @Override
    public int compareTo(@NotNull ManagerSlot o) {
        return 0;
    }

    @Override
    public Collection<SlotMetadata> getMetadata() {
        return null;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        return false;
    }

    public boolean keyPressed(int key, int value, int modifier) {
        return false;
    }

    @Override
    public List<? extends Slot> getChildSlots(int listWidth, int columnWidth) {
        return null;
    }

    @Override
    public SlotMetadata getLastPressed() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public int getColumnWidth() {
        return 0;
    }

    @Override
    public boolean contains(SlotMetadata slotMetadata) {
        return false;
    }

    public void render(GuiGraphics graphics, int slotIndex, int y, int x, int listWidth, int itemHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        this.y = y;
        this.x = x;
        this.listWidth = listWidth;
        this.itemHeight = itemHeight;
        boolean drawHovered = isMouseOver;
        Integer color = drawHovered ? backgroundHover : background;
        float alpha = drawHovered ? 1.0f : 0.4f;
        this.renderSlot(graphics, x, y, listWidth, itemHeight, color, alpha);
    }

    public void renderGhost(GuiGraphics graphics, int mouseX, int mouseY) {
        int xOffset = (int)((double)mouseX - (this.dragX - (double)this.x));
        int yOffest = (int)((double)mouseY - (this.dragY - (double)this.y));
        graphics.pose().translate(0.0f, 0.0f, 1.0f);
        this.renderSlot(graphics, xOffset, yOffest, this.listWidth, this.itemHeight, backgroundHover, 0.2f);
    }

    private void renderSlot(GuiGraphics graphics, int x, int y, int listWidth, int itemHeight, int color, float alpha) {
        DrawUtil.drawRectangle(graphics, x, y, listWidth, itemHeight, color, alpha);
        this.outline(graphics, x, y, listWidth, itemHeight, 0xC0C0C0, alpha * 2.0f);
        graphics.drawString(Minecraft.getInstance().font, this.waypoint.getName(), x, y, -1);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.dragX = mouseX;
        this.dragY = mouseY;
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.dragging) {
            this.dragging = this.isMouseOver(mouseX, mouseY);
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean isDragging() {
        return this.dragging;
    }

    @NotNull
    public Waypoint getWaypoint() {
        return this.waypoint;
    }
}

