/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.waypoint.WaypointSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class WaypointPanel<T extends WaypointSlot>
extends ScrollListPane<T> {
    final int offset = 8;
    WaypointSlot draggingSlot = null;

    public WaypointPanel(Minecraft mc, int x, int y, int width, int height, int slotHeight) {
        super(mc, x, y, width, height, slotHeight);
    }

    public int getRowLeft() {
        return super.getRowLeft();
    }

    @Override
    public void updateSize(int width, int height, int x, int y) {
        super.setRectangle(width, height, x - 4, y);
        this.scrollbarX = this.width + x;
        this.listWidth = this.width - 8;
    }

    @Override
    public void setListWidth(int width) {
        this.scrollbarX = (this.width + width) / 2;
        this.listWidth = width - 8;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        try {
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    @Override
    public void renderListItems(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        try {
            super.renderListItems(graphics, mouseX, mouseY, partialTicks);
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    public void renderItem(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
        try {
            WaypointSlot slot = (WaypointSlot)this.getEntry(index);
            super.renderItem(graphics, mouseX, mouseY, partialTick, index, left, top, width, height);
            if (slot.isDragging()) {
                this.draggingSlot = slot;
            }
            if (this.draggingSlot != null && (this.getRowBottom(index + 1) > this.getBottom() || index + 1 >= this.children().size())) {
                graphics.disableScissor();
                this.draggingSlot.renderGhost(graphics, mouseX, mouseY);
                this.enableScissor(graphics);
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    public void renderSelection(GuiGraphics guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
        try {
            int i = this.getRowLeft() - 1;
            int j = this.getRowLeft() + width + 2;
            guiGraphics.fill(i, top - 1, j, top + height + 2, -1);
            guiGraphics.fill(i + 1, top, j - 1, top + height + 1, innerColor);
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int i, int j, float f) {
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingSlot = null;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public WaypointSlot getDraggingSlot() {
        return this.draggingSlot;
    }
}

