/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.log.JMLogger;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.popupscreenbutton.PopupButton;
import journeymap.client.ui.component.screens.TwoColumnScreen;
import journeymap.client.ui.waypoint.DimensionsDropDownButton;
import journeymap.client.ui.waypoint.WaypointPanel;
import journeymap.client.ui.waypoint.WaypointSlot;
import journeymap.client.ui.waypoint.group.EditGroupPopup;
import journeymap.client.ui.waypoint.group.GroupPanel;
import journeymap.client.ui.waypoint.group.GroupSlot;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class WaypointManager
extends TwoColumnScreen<GroupPanel<GroupSlot>, WaypointPanel<WaypointSlot>> {
    private final ClientWaypointImpl focusWaypoint;
    private Map<WaypointGroup, GroupSlot> groupMap;
    private GroupPanel<GroupSlot> groupPanel;
    private static WaypointGroup selectedGroup = WaypointGroupStore.ALL;
    private GroupSlot draggingGroup;
    private final Map<WaypointGroup, WaypointPanel<WaypointSlot>> panelMap = new HashMap<WaypointGroup, WaypointPanel<WaypointSlot>>();
    private Button createGroupButton;
    int sidePanelSize = 120;
    int panelYOffset = 25;

    public WaypointManager(Screen returnDisplay) {
        this(null, returnDisplay);
    }

    public WaypointManager(ClientWaypointImpl focusWaypoint, Screen returnDisplay) {
        super(Constants.getString("jm.waypoint.manage_title"), true, returnDisplay, null, null);
        this.minecraft = Minecraft.getInstance();
        this.focusWaypoint = focusWaypoint;
        this.groupMap = this.buildGroupSlots();
    }

    @Override
    public void init() {
        this.footerLayout.addChild((LayoutElement)new DimensionsDropDownButton(this::updateDimFilter));
        super.init();
        try {
            this.groupPanel = new GroupPanel(this.minecraft, this, 1, 36 + this.panelYOffset, this.sidePanelSize - 1, this.height - 66 - 25, 20);
            this.groupPanel.setSlots(this.groupMap.values().stream().toList());
            this.createGroupButton = new PopupButton<String>(0, 0, "New Group", () -> new EditGroupPopup((Component)Component.translatable((String)"Input new group name")), this::addNewGroup);
            this.addRenderableWidget((GuiEventListener)this.createGroupButton);
            this.addRenderableWidget((GuiEventListener)this.groupPanel);
            this.addRenderableWidget((GuiEventListener)this.getWaypointPanel(selectedGroup));
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error in WaypointManager.init(): {}", t);
        }
    }

    @Override
    protected GroupPanel<GroupSlot> getLeftPane() {
        return null;
    }

    @Override
    protected WaypointPanel<WaypointSlot> getRightPane() {
        return null;
    }

    @Override
    protected void repositionElements() {
        super.repositionElements();
        this.groupPanel.updateSize(this.sidePanelSize - 1, this.height - 22 - 66 - this.panelYOffset, 1, 36 + this.panelYOffset);
        this.groupPanel.updateSlots();
        this.groupPanel.setScrollAmount(0.0);
        this.groupMap.keySet().forEach(group -> {
            WaypointPanel<WaypointSlot> waypointPanel = this.getWaypointPanel((WaypointGroup)group);
            waypointPanel.updateSize(this.width - this.sidePanelSize - 12, this.height - 66 - this.panelYOffset, this.sidePanelSize + 4, 36 + this.panelYOffset);
            waypointPanel.updateSlots();
            waypointPanel.setScrollAmount(0.0);
        });
        this.createGroupButton.fitWidth(this.font);
        this.createGroupButton.setY(this.groupPanel.getBottom() + 2);
        this.createGroupButton.setX(this.sidePanelSize / 2 - this.createGroupButton.getWidth() / 2);
    }

    private void updateDimFilter(net.minecraft.client.gui.components.Button button) {
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float par3) {
        GroupPanel<GroupSlot> panelUnderMouse;
        GroupSlot groupSlot;
        WaypointGroup group;
        super.render(graphics, x, y, par3);
        this.outline(graphics, 0, 36, this.width - 1, this.height - 66);
        DrawUtil.drawRectangle(graphics, this.sidePanelSize, 36.0, 1.0, this.height - 66, 0xC0C0C0, 0.8f);
        DrawUtil.drawRectangle(graphics, 0.0, 56.0, this.width - 1, 1.0, 0xC0C0C0, 0.8f);
        graphics.drawString(this.font, "Groups", this.sidePanelSize / 2 - 23, 42, -1);
        graphics.drawString(this.font, "Waypoints", this.sidePanelSize + 10, 42, -1);
        Optional child = this.groupPanel.getChildAt(x, y);
        if (this.getWaypointPanel(selectedGroup).getDraggingSlot() != null && child.isPresent() && (group = (groupSlot = (GroupSlot)child.get()).getGroup()) != null) {
            boolean transferable = WaypointGroupStore.getInstance().canTransferWaypoint(group, this.getWaypointPanel(selectedGroup).getDraggingSlot().getWaypoint());
            groupSlot.renderTransferStatus(graphics, transferable);
        }
        ScrollListPane scrollListPane = child.isPresent() ? this.groupPanel : (panelUnderMouse = this.getWaypointPanel(selectedGroup).getChildAt(x, y).isPresent() ? this.getWaypointPanel(selectedGroup) : null);
        if (panelUnderMouse != null) {
            List<FormattedCharSequence> lastTooltip = panelUnderMouse.lastTooltip;
            long lastTooltipTime = panelUnderMouse.lastTooltipTime;
            if (panelUnderMouse.lastTooltip != null && panelUnderMouse.lastTooltip.equals(lastTooltip)) {
                panelUnderMouse.lastTooltipTime = lastTooltipTime;
                if (System.currentTimeMillis() - panelUnderMouse.lastTooltipTime > panelUnderMouse.hoverDelay) {
                    graphics.renderTooltip(this.font, panelUnderMouse.lastTooltip, x, y + 15);
                }
            }
        }
    }

    private void fillBackground(GuiGraphics graphics, ScrollListPane panel) {
        DrawUtil.drawRectangle(graphics, panel.getX(), panel.getY(), panel.getWidth() - 1, panel.getHeight(), new Color(20, 20, 20).getRGB(), 0.95f);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean groupClicked = this.groupPanel.mouseClicked(mouseX, mouseY, button);
        if (button == 0) {
            Slot groupSelected = (Slot)this.groupPanel.getSelected();
            if (groupSelected != null && groupClicked) {
                this.updateSelectedGroup(groupSelected);
                return true;
            }
            boolean waypointClicked = this.getWaypointPanel(selectedGroup).mouseClicked(mouseX, mouseY, button);
            Slot slot = (Slot)this.getWaypointPanel(selectedGroup).getSelected();
        }
        if (groupClicked) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void updateSelectedGroup(Slot groupSelected) {
        this.groupPanel.unselect();
        this.removeWidget((GuiEventListener)this.getWaypointPanel(selectedGroup));
        selectedGroup = ((GroupSlot)groupSelected).getGroup();
        this.getWaypointPanel(selectedGroup).setSlots(this.getWaypointsForGroup(selectedGroup));
        this.addRenderableWidget((GuiEventListener)this.getWaypointPanel(selectedGroup));
        ((GroupSlot)groupSelected).setSelected(true);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        Optional child = this.groupPanel.getChildAt(mouseX, mouseY);
        if (this.getWaypointPanel(selectedGroup).getDraggingSlot() != null && child.isPresent()) {
            WaypointGroup groupTo = ((GroupSlot)child.get()).getGroup();
            Waypoint waypoint = this.getWaypointPanel(selectedGroup).getDraggingSlot().getWaypoint();
            WaypointGroup groupFrom = WaypointGroupStore.getInstance().get(waypoint.getGroupId());
            boolean didTransfer = groupTo.addWaypoint(waypoint);
            if (didTransfer && !WaypointGroupStore.ALL.getGuid().equals(selectedGroup.getGuid())) {
                this.getWaypointPanel(selectedGroup).setSlots(this.getWaypointsForGroup(groupFrom));
            }
        }
        boolean groupMouseReleased = this.groupPanel.mouseReleased(mouseX, mouseY, button);
        boolean waypointsMouseReleased = this.getWaypointPanel(selectedGroup).mouseReleased(mouseX, mouseY, button);
        return groupMouseReleased || waypointsMouseReleased;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.groupPanel.mouseDragged(mouseX, mouseY, button, dragX, dragY) || this.getWaypointPanel(selectedGroup).mouseDragged(mouseX, mouseY, button, dragX, dragY) || super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean groupScrolled = false;
        boolean waypointsScrolled = false;
        WaypointPanel<WaypointSlot> waypointPanel = this.getWaypointPanel(selectedGroup);
        if (this.groupPanel.isMouseOver(mouseX, mouseY)) {
            groupScrolled = this.groupPanel.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        } else if (waypointPanel.isMouseOver(mouseX, mouseY)) {
            waypointsScrolled = this.getWaypointPanel(selectedGroup).mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return groupScrolled || waypointsScrolled;
    }

    private void outline(GuiGraphics graphics, int x, int y, int width, int height) {
        int color = 0xC0C0C0;
        float alpha = 0.8f;
        DrawUtil.drawRectangle(graphics, x, y, width, 1.0, color, alpha);
        DrawUtil.drawRectangle(graphics, x, y + height, width, 1.0, color, alpha);
        DrawUtil.drawRectangle(graphics, x, y, 1.0, height, color, alpha);
        DrawUtil.drawRectangle(graphics, x + width, y, 1.0, height + 1, color, alpha);
    }

    protected Map<WaypointGroup, GroupSlot> buildGroupSlots() {
        LinkedHashMap<WaypointGroup, GroupSlot> map = new LinkedHashMap<WaypointGroup, GroupSlot>();
        map.put(WaypointGroupStore.ALL, new GroupSlot(WaypointGroupStore.ALL, this.width, this.height));
        WaypointGroupStore.getInstance().getAll().forEach(group -> map.put((WaypointGroup)group, new GroupSlot((WaypointGroup)group, this.width, this.height)));
        return map;
    }

    protected List<WaypointSlot> getWaypointsForGroup(WaypointGroup group) {
        return group.getWaypointIds().stream().map(id -> WaypointStore.getInstance().get((String)id)).toList().stream().map(WaypointSlot::new).toList();
    }

    private void addNewGroup(String name) {
        if (name != null && !name.isEmpty()) {
            WaypointGroup group = WaypointFactoryImpl.instance.createWaypointGroup(name);
            WaypointGroupStore.getInstance().put(group);
            this.updateGroupSlots();
        }
    }

    private void updateGroupSlots() {
        this.groupMap = this.buildGroupSlots();
        this.groupPanel.setSlots(this.groupMap.values().stream().toList());
    }

    private WaypointPanel<WaypointSlot> getWaypointPanel(WaypointGroup group) {
        WaypointPanel<WaypointSlot> panel = this.panelMap.get(group);
        if (panel == null) {
            panel = new WaypointPanel(this.minecraft, this.sidePanelSize + 4, 36 + this.panelYOffset, this.width - this.sidePanelSize - 12, this.height - 66 - this.panelYOffset, 20);
            panel.setSlots(this.getWaypointsForGroup(group));
            this.panelMap.put(group, panel);
        }
        return panel;
    }
}

