/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.minimap;

import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import journeymap.api.v2.client.option.KeyedEnum;
import journeymap.client.Constants;
import journeymap.client.model.EntityDTO;
import journeymap.client.render.draw.MobIconCache;
import journeymap.client.texture.Texture;
import journeymap.client.texture.TextureCache;
import net.minecraft.resources.ResourceLocation;

public enum EntityDisplay implements KeyedEnum
{
    Dots("jm.common.entity_display.dots", TextureCache.MobDot, null, TextureCache.MobDotArrow, null),
    Icons("jm.common.entity_display.icons", null, null, null, null),
    OutlinedIcons("jm.common.entity_display.outlined_icons", null, null, null, null),
    DotsAndIcons("jm.common.entity_display.dots_and_icons", TextureCache.MobIcon, TextureCache.MobIconBG, TextureCache.MobIconArrow, TextureCache.MobIconArrowBG),
    DotsAndOutlinedIcons("jm.common.entity_display.dots_and_outlined_icons", TextureCache.MobIcon, TextureCache.MobIconBG, TextureCache.MobIconArrow, TextureCache.MobIconArrowBG);

    public final String key;
    private final ResourceLocation defaultTexture;
    private final ResourceLocation defaultBGTexture;
    private final ResourceLocation showHeadingTexture;
    private final ResourceLocation showHeadingBGTexture;

    private EntityDisplay(String key, ResourceLocation defaultTexture, ResourceLocation defaultBGTexture, ResourceLocation showHeadingTexture, ResourceLocation showHeadingBGTexture) {
        this.key = key;
        this.defaultTexture = defaultTexture;
        this.defaultBGTexture = defaultBGTexture;
        this.showHeadingTexture = showHeadingTexture;
        this.showHeadingBGTexture = showHeadingBGTexture;
    }

    public static Texture getLocatorTexture(EntityDisplay entityDisplay, boolean showHeading) {
        return TextureCache.getTexture(showHeading ? entityDisplay.showHeadingTexture : entityDisplay.defaultTexture);
    }

    public static Texture getLocatorBGTexture(EntityDisplay entityDisplay, boolean showHeading) {
        return TextureCache.getTexture(showHeading ? entityDisplay.showHeadingBGTexture : entityDisplay.defaultBGTexture);
    }

    public static Texture getEntityTexture(EntityDisplay entityDisplay, GameProfile profile) {
        switch (entityDisplay.ordinal()) {
            case 0: {
                return TextureCache.getTexture(TextureCache.MobDotChevron);
            }
        }
        if (!Strings.isNullOrEmpty((String)profile.getName())) {
            return TextureCache.getPlayerSkin(profile);
        }
        return null;
    }

    public static Texture getEntityTexture(EntityDisplay entityDisplay, EntityDTO dto) {
        Texture tex;
        if (entityDisplay != Dots && (tex = MobIconCache.getMobIcon(dto, entityDisplay == OutlinedIcons || entityDisplay == DotsAndOutlinedIcons)) != null) {
            return tex;
        }
        return TextureCache.getTexture(TextureCache.MobDotChevron);
    }

    public static boolean hasEntityIcon(EntityDisplay entityDisplay, EntityDTO dto) {
        return MobIconCache.getMobIcon(dto, entityDisplay == OutlinedIcons || entityDisplay == DotsAndOutlinedIcons) != null;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return Constants.getString(this.key);
    }

    public boolean isDots() {
        return this == Dots;
    }

    public boolean isOutlined() {
        return this == OutlinedIcons || this == DotsAndOutlinedIcons;
    }

    public EntityDisplay getDot() {
        if (this == Icons || this == OutlinedIcons || this == DotsAndIcons || this == DotsAndOutlinedIcons) {
            return Dots;
        }
        return this;
    }
}

