/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.popupscreenbutton.blockflags;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.model.BlockFlag;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class BlockFlagsScreen
extends PopupButtonScreen<BlockFlagsResponse> {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.parse((String)"popup/background");
    private final LinearLayout layout = LinearLayout.vertical();
    private final List<BlockFlag> validFlags = List.of(BlockFlag.Ignore, BlockFlag.Foliage, BlockFlag.Grass, BlockFlag.Water, BlockFlag.Fluid, BlockFlag.OpenToSky, BlockFlag.NoShadow, BlockFlag.Transparency, BlockFlag.Plant, BlockFlag.Crop, BlockFlag.NoTopo, BlockFlag.Force);
    private final Component labelSubmit = Component.translatable((String)"jm.common.submit");
    private final Component labelReset = Component.translatable((String)"jm.common.reset");
    private final Component labelCancel = Component.translatable((String)"jm.common.cancel");
    private final List<CheckBox> checkFlags = new ArrayList<CheckBox>();
    private final EnumSet<BlockFlag> originalFlags;
    private EnumSet<BlockFlag> currentFlags;

    protected BlockFlagsScreen(EnumSet<BlockFlag> flags) {
        super((Component)Component.empty());
        this.response = new BlockFlagsResponse(flags, true);
        this.originalFlags = flags.clone();
        this.currentFlags = flags.clone();
    }

    public void init() {
        this.layout.spacing(12).defaultCellSetting().alignHorizontallyCenter();
        LinearLayout columnsLayout = LinearLayout.horizontal();
        columnsLayout.spacing(24).defaultCellSetting().alignVerticallyTop();
        LinearLayout leftColumnLayout = LinearLayout.vertical();
        leftColumnLayout.spacing(12).defaultCellSetting().alignHorizontallyLeft();
        LinearLayout rightColumnLayout = LinearLayout.vertical();
        rightColumnLayout.spacing(12).defaultCellSetting().alignHorizontallyLeft();
        int count = 0;
        for (BlockFlag flag : this.validFlags) {
            CheckBox check = new CheckBox(Constants.getTranslatedTextComponent(flag.getKey()).getString(), this.currentFlags.contains((Object)flag), this::checkToggled);
            this.checkFlags.add(check);
            if (count < this.validFlags.size() / 2) {
                leftColumnLayout.addChild((LayoutElement)check);
            } else {
                rightColumnLayout.addChild((LayoutElement)check);
            }
            ++count;
        }
        columnsLayout.addChild((LayoutElement)leftColumnLayout);
        columnsLayout.addChild((LayoutElement)rightColumnLayout);
        this.layout.addChild((LayoutElement)columnsLayout);
        LinearLayout bottomButtons = LinearLayout.horizontal();
        bottomButtons.spacing(12);
        bottomButtons.addChild((LayoutElement)Button.builder((Component)this.labelSubmit, b -> this.setResponseAndClose(new BlockFlagsResponse(this.currentFlags, false))).width(this.font.width((FormattedText)this.labelSubmit) + 10).build());
        bottomButtons.addChild((LayoutElement)Button.builder((Component)this.labelReset, b -> this.reset()).width(this.font.width((FormattedText)this.labelReset) + 10).build());
        bottomButtons.addChild((LayoutElement)Button.builder((Component)this.labelCancel, b -> this.setResponseAndClose(new BlockFlagsResponse(this.originalFlags, true))).width(this.font.width((FormattedText)this.labelCancel) + 10).build());
        this.layout.addChild((LayoutElement)bottomButtons);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    @Override
    public void renderPopupScreenBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(graphics);
        graphics.blitSprite(BACKGROUND_SPRITE, this.layout.getX() - 18, this.layout.getY() - 18, this.layout.getWidth() + 36, this.layout.getHeight() + 36);
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }

    private void checkToggled(net.minecraft.client.gui.components.Button button) {
        CheckBox check = (CheckBox)button;
        int index = this.checkFlags.indexOf(check);
        BlockFlag flag = this.validFlags.get(index);
        if (check.getToggled().booleanValue()) {
            this.currentFlags.add(flag);
        } else {
            this.currentFlags.remove((Object)flag);
        }
    }

    private void reset() {
        this.currentFlags = this.originalFlags.clone();
        for (int i = 0; i < this.validFlags.size(); ++i) {
            this.checkFlags.get(i).setToggled(this.currentFlags.contains((Object)this.validFlags.get(i)));
        }
    }

    public record BlockFlagsResponse(EnumSet<BlockFlag> flags, boolean canceled) {
    }
}

